/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.ParentMemberRule;
import kd.bos.algo.olap.dbsource.Table;
import kd.bos.algo.olap.def.HierarchyDef;
import kd.bos.algo.olap.def.LevelDef;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.HierarchyImpl;
import kd.bos.algo.olap.impl.LevelFetch;
import kd.bos.algo.olap.impl.LevelImpl;
import kd.bos.algo.olap.impl.MemberComparator;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.MemberTreeNode;

class HierarchyFetch {
    LevelImpl[] levels;
    LevelDef[] levelDefs;
    LevelFetch[] levelFetchs;
    int levelCount;
    MemberTreeNode root = new MemberTreeNode();
    HierarchyImpl hie;
    int memberCount = 0;
    int globalOrder = 0;

    public HierarchyFetch(HierarchyDef def, HierarchyImpl _hie) {
        this.hie = _hie;
        this.levels = this.hie.levels;
        this.levelDefs = def.levels;
        this.levelCount = this.levels.length;
        this.levelFetchs = new LevelFetch[this.levelCount];
        int i = 0;
        while (i < this.levelCount) {
            this.levelFetchs[i] = new LevelFetch(this.levels[i], this.levelDefs[i]);
            ++i;
        }
        this.root.childrenByKey = new HashMap();
        if (def.hasAll) {
            LevelImpl allLevel = new LevelImpl();
            allLevel.hie = this.hie;
            allLevel.depth = 0;
            allLevel.parent = null;
            allLevel.child = this.levels[0];
            this.levels[0].parent = allLevel;
            allLevel.levelType = (byte)-1;
            LevelImpl[] ls = new LevelImpl[this.levels.length + 1];
            System.arraycopy(this.levels, 0, ls, 1, this.levels.length);
            ls[0] = allLevel;
            this.hie.levels = ls;
            MemberImpl allMember = new MemberImpl();
            if (def.allMemberName != null) {
                allMember.setName(def.allMemberName);
            }
            allMember.memberType = (byte)8;
            allMember.level = allLevel;
            allMember.ordinal = 0;
            this.root.member = allMember;
        }
    }

    MemberImpl fetch(Table table) throws OlapException {
        MemberTreeNode current = this.root;
        int i = 0;
        while (i < this.levelCount) {
            if ((current = this.levelFetchs[i].fetch(current, table)) == null) {
                return null;
            }
            ++i;
        }
        return (MemberImpl)current.member;
    }

    private void renderMember(MemberImpl member) {
        member.globalOrder = this.globalOrder++;
        ++this.memberCount;
        ((DimensionImpl)member.getDimension()).mapOrderToMember.put(member.globalOrder, member);
    }

    void finish() throws OlapException {
        if (this.root.member != null) {
            this.renderMember((MemberImpl)this.root.member);
        }
        MemberImpl[] ms = this.buildMembers(this.root, true);
        if (this.root.member == null) {
            this.hie.setMembers(ms);
        } else {
            ((MemberImpl)this.root.member).setChildren(ms);
            MemberImpl[] ms2 = new MemberImpl[]{(MemberImpl)this.root.member};
            this.hie.setMembers(ms2);
        }
        this.hie.memberCount = this.memberCount;
        int i = 0;
        while (i < this.levelFetchs.length) {
            this.levelFetchs[i].finish();
            ++i;
        }
    }

    MemberImpl[] buildMembers(MemberTreeNode tree, boolean buildParentChild) throws OlapException {
        if (tree.childrenByKey == null) {
            return null;
        }
        MemberTreeNode[] items = new MemberTreeNode[tree.childrenByKey.size()];
        tree.childrenByKey.values().toArray(items);
        if (items.length == 0) {
            return new MemberImpl[0];
        }
        LevelDef levelDef = items[0].levelDef;
        if (buildParentChild && levelDef.parentColumn != null) {
            ParentMemberRule rule = null;
            items = this.buildParentChildMembers(items, tree.childrenByKey, rule);
        }
        MemberImpl[] members = new MemberImpl[items.length];
        int i = 0;
        while (i < items.length) {
            this.renderMember((MemberImpl)items[i].member);
            ++i;
        }
        i = 0;
        while (i < items.length) {
            members[i] = (MemberImpl)items[i].member;
            members[i].setChildren(this.buildMembers(items[i], false));
            ++i;
        }
        if (levelDef.orderBy != null) {
            Arrays.sort(members, new MemberComparator(levelDef.orderBy, levelDef.orderMethod));
        }
        i = 0;
        while (i < members.length) {
            members[i].ordinal = i;
            ++i;
        }
        if (buildParentChild && levelDef.parentColumn != null) {
            this.buildParentChildLevels(members, levelDef.maxDepth);
        }
        return members;
    }

    void buildParentChildLevels(MemberImpl[] members, int maxDepth) {
        if (maxDepth <= 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        int i = 0;
        while (i < members.length) {
            this.buildParentChildLevels(members[i], maxDepth - 1);
            ++i;
        }
    }

    void buildParentChildLevels(MemberImpl member, int maxDepth) {
        MemberImpl[] children = member.getChildren();
        if (maxDepth == 0) {
            member.setChildren(null);
        }
        if (children == null || children.length == 0) {
            return;
        }
        LevelImpl level = member.level;
        LevelImpl childLevel = level.createChildLevel();
        int i = 0;
        while (i < children.length) {
            MemberImpl child = children[i];
            child.level = childLevel;
            this.buildParentChildLevels(child, maxDepth - 1);
            ++i;
        }
    }

    MemberTreeNode[] buildParentChildMembers(MemberTreeNode[] items, HashMap all, ParentMemberRule rule) throws OlapException {
        ArrayList<MemberTreeNode> v = new ArrayList<MemberTreeNode>();
        int i = 0;
        while (i < items.length) {
            MemberTreeNode item = items[i];
            Object parentItem = null;
            if (item.parentValue != null) {
                Object parentKey = item.parentValue;
                if (rule != null) {
                    parentKey = rule.getParentValue(parentKey);
                }
                parentItem = (MemberTreeNode)all.get(parentKey);
            }
            if (parentItem == null) {
                v.add(item);
            } else if (parentItem.equals(item)) {
                v.add(item);
            } else {
                if (((MemberTreeNode)parentItem).childrenByKey == null) {
                    ((MemberTreeNode)parentItem).childrenByKey = new HashMap();
                }
                ((MemberTreeNode)parentItem).childrenByKey.put(item.childValue, item);
                ((MemberImpl)item.member).parent = (MemberImpl)((MemberTreeNode)parentItem).member;
            }
            ++i;
        }
        items = v.toArray(new MemberTreeNode[v.size()]);
        return items;
    }
}

