/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.HashMap;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.Table;
import kd.bos.algo.olap.def.LevelDef;
import kd.bos.algo.olap.def.PropertyDef;
import kd.bos.algo.olap.impl.Field;
import kd.bos.algo.olap.impl.LevelImpl;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.MemberTreeNode;
import kd.bos.algo.olap.util.Util;

class LevelFetch {
    Field field;
    Field[] propFields = new Field[0];
    PropertyDef[] props = new PropertyDef[0];
    String[] propDataTypes = new String[0];
    LevelImpl level;
    LevelDef def;
    Field childField = null;
    Field parentField = null;
    Field orderByField = null;

    LevelFetch(LevelImpl _level, LevelDef _def) {
        this.def = _def;
        this.level = _level;
        this.field = new Field(this.def.column);
        this.field.type = this.level.levelType;
        if (this.def.parentColumn != null) {
            this.parentField = new Field(this.def.parentColumn);
        }
        if (this.def.childColumn != null) {
            this.childField = new Field(this.def.childColumn);
        }
        if (this.def.properties != null) {
            this.props = this.def.properties;
            this.propFields = new Field[this.props.length];
            this.propDataTypes = new String[this.props.length];
            int i = 0;
            while (i < this.propFields.length) {
                this.propFields[i] = new Field(this.props[i].column);
                this.propDataTypes[i] = this.props[i].dataType;
                if (this.props[i].name.equals("weight")) {
                    this.level.getDimension().setHasWeight(true);
                }
                ++i;
            }
        }
        if (this.def.orderBy != null) {
            this.orderByField = new Field(this.def.orderBy);
        }
    }

    MemberTreeNode fetch(MemberTreeNode parent, Table table) throws OlapException {
        MemberTreeNode item;
        Object key = this.field.getValue(table);
        if (key == null) {
            return null;
        }
        Object childKey = key;
        if (this.childField != null) {
            childKey = this.childField.getValue(table);
        }
        if (parent.childrenByKey == null) {
            parent.childrenByKey = new HashMap();
        }
        if (parent.childrenByName == null) {
            parent.childrenByName = new HashMap();
        }
        if ((item = (MemberTreeNode)parent.childrenByKey.get(childKey)) == null) {
            MemberImpl member = new MemberImpl();
            member.level = this.level;
            member.memberType = 1;
            member.setKey(key);
            member.parent = (MemberImpl)parent.member;
            int i = 0;
            while (i < this.props.length) {
                if (this.propFields[i] != null) {
                    Object value = this.propFields[i].getValue(table);
                    member.setProperty(this.props[i].name, value);
                    if (this.propDataTypes[i] == null) {
                        this.propDataTypes[i] = Util.decideDataType(value);
                    }
                }
                ++i;
            }
            if (this.orderByField != null) {
                Object value = this.orderByField.getValue(table);
                member.setProperty("orderBy", value);
            }
            item = new MemberTreeNode();
            item.member = member;
            if (this.parentField != null) {
                item.childValue = childKey;
                item.parentValue = this.parentField.getValue(table);
            }
            item.levelDef = this.def;
            parent.childrenByKey.put(childKey, item);
        }
        return item;
    }

    public void finish() {
        if (this.level.props == null) {
            return;
        }
        int i = 0;
        while (i < this.level.props.length) {
            this.level.props[i].setProperty("dataType", this.propDataTypes[i]);
            ++i;
        }
    }
}

