/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.impl.ConnectionImpl;
import kd.bos.algo.olap.impl.CubeEvaluateContext;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.calc.Calc;

public class LinkCellReader {
    private final SchemaReader schemaReader;
    private final CubeEvaluateContext context;
    private final Evaluator evaluator;

    public LinkCellReader(ConnectionImpl con) {
        this.schemaReader = con.getSchemaReader();
        this.context = con.getDatabase().getEvaluateContext();
        this.evaluator = this.context.createEvaluator();
    }

    public LinkCellReader(SchemaReader schemaReader, CubeEvaluateContext context) {
        this.schemaReader = schemaReader;
        this.context = context;
        this.evaluator = context.createEvaluator();
    }

    public Object get(Member[] carryMembers, String[] overideMembers) {
        Member[] memberArray = carryMembers;
        int n = carryMembers.length;
        int n2 = 0;
        while (n2 < n) {
            Member member = memberArray[n2];
            if (!member.isMeasure() && this.schemaReader.getCube().getDimension(member.getDimension().getName()) != null) {
                this.evaluator.setContext(this.schemaReader.getMemberByUniqueName(member.getUniqueName()));
            }
            ++n2;
        }
        String[] stringArray = overideMembers;
        int n3 = overideMembers.length;
        int n4 = 0;
        while (n4 < n3) {
            String memberExpr = stringArray[n4];
            Exp exp = this.context.parseExpression(memberExpr, true);
            Calc calc = this.context.compileExpression(exp, false);
            Object o = calc.evaluate(this.evaluator);
            if (!(o instanceof Member)) {
                throw new OlapException("LinkValue " + memberExpr + " is not member.");
            }
            this.evaluator.setContext(o);
            ++n4;
        }
        return this.evaluator.evaluateCurrent();
    }
}

