/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.LeafFeature;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.MemberScope;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.DefaultListFactory;
import kd.bos.algo.olap.collection.IMemberList;
import kd.bos.algo.olap.impl.CubeElementBase;
import kd.bos.algo.olap.impl.EvaluatorImpl;
import kd.bos.algo.olap.impl.HasData;
import kd.bos.algo.olap.impl.LevelImpl;
import kd.bos.algo.olap.impl.MemberIndex;
import kd.bos.algo.olap.impl.MemberScopeImpl;
import kd.bos.algo.olap.impl.ScopedCalc;
import kd.bos.algo.olap.mdx.DelegatingExpResolver;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.Syntax;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.elementexp.MemberExpr;
import kd.bos.algo.olap.mdx.type.MemberType;
import kd.bos.algo.olap.mdx.type.Type;
import kd.bos.algo.olap.util.IntBitSet;
import kd.bos.algo.olap.util.RoaringIntBitSet;
import kd.bos.algo.olap.util.UniqueNameUtil;
import kd.bos.algo.olap.util.Util;

public class MemberImpl
extends CubeElementBase
implements Member {
    public static final long serialVersionUID = 41234543357636L;
    byte memberType = 1;
    int ordinal;
    int globalOrder;
    int dataType;
    LevelImpl level;
    MemberImpl parent;
    private MemberImpl[] children;
    protected transient String uniqueName;
    private transient Dimension dimension;
    private transient Hierarchy hierarchy;
    protected HasData hasData = new HasData();
    private boolean hasSelfData;
    private boolean childrenHasSelfData;
    private Number weight = null;
    private MemberIndex childrenIndex;
    private Exp exp;
    private boolean desendantHasExpression;
    private Exp aggExp;
    private LeafFeature leafFeature;
    private boolean hasDisableAgg;
    private int cellCalculationIndex = -1;
    private RoaringIntBitSet filterBitSet = new RoaringIntBitSet();
    private Calc calc;
    private List<ScopedCalc> scopedCalcList = null;

    public MemberImpl() {
        this.childrenIndex = new MemberIndex(false);
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public void setHasData(boolean hasData) {
        this.hasData.hasData = hasData;
        if (this.parent != null) {
            this.parent.setHasData(hasData);
        }
    }

    @Override
    public Dimension getDimension() {
        if (this.dimension == null) {
            this.dimension = this.getHierarchy().getDimension();
        }
        return this.dimension;
    }

    @Override
    public Hierarchy getHierarchy() {
        if (this.hierarchy == null) {
            this.hierarchy = this.level.getHierarchy();
        }
        return this.hierarchy;
    }

    @Override
    public Member getParentMember() {
        return this.parent;
    }

    @Override
    public String getParentUniqueName() {
        return this.parent.getUniqueName();
    }

    @Override
    public Number getWeight() {
        return this.weight;
    }

    public void setWeight(Number weight) {
        this.weight = weight;
        this.dimension.setHasWeight(true);
    }

    public boolean hasDisableAgg() {
        return this.hasDisableAgg;
    }

    public void setHasDisableAgg(boolean hasDisableAgg) {
        this.hasDisableAgg = hasDisableAgg;
        this.dimension.setHasDisableAgg(true);
    }

    @Override
    public void setProperty(String name, Object value) {
        if ("weight".equals(name)) {
            this.weight = (Number)value;
        }
        if ("disableAgg".equals(name)) {
            boolean bl = this.hasDisableAgg = value != null && (Integer)value == 1;
            if (this.hasDisableAgg) {
                this.getDimension().setHasDisableAgg(true);
            }
        }
        super.setProperty(name, value);
    }

    @Override
    public IMemberList getChildMembers() {
        return DefaultListFactory.instance.createMemberList(this.children);
    }

    @Override
    public IMemberList getAncestorMembers() {
        IMemberList list = DefaultListFactory.instance.createMemberList();
        Member parentMember = this.getParentMember();
        while (parentMember != null) {
            list.add(parentMember);
            parentMember = parentMember.getParentMember();
        }
        return list;
    }

    @Override
    public Object getKey() {
        return this.getProperty("key");
    }

    void setKey(Object key) {
        this.setProperty("key", key);
    }

    @Override
    public byte getMemberType() {
        return this.memberType;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public final int getGlobalOrder() {
        return this.globalOrder;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    public Type getExpType() {
        return new MemberType(this.getHierarchy(), this.getLevel(), null);
    }

    public int getCategory() {
        return 6;
    }

    @Override
    public boolean isNull() {
        return (this.memberType & 0x10) == 16;
    }

    @Override
    public boolean isAll() {
        return (this.memberType & 8) == 8;
    }

    @Override
    public boolean isMeasure() {
        return (this.memberType & 2) == 2;
    }

    @Override
    public boolean isCalculated() {
        return false;
    }

    @Override
    public final boolean isLeaf() {
        return this.children == null || this.children.length == 0;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name) throws OlapException {
        return this.childrenIndex.get(name);
    }

    public void setChildren(MemberImpl[] members) {
        this.children = members;
        if (members == null) {
            return;
        }
        int i = 0;
        while (i < members.length) {
            this.childrenIndex.put(members[i].getName(), members[i]);
            ++i;
        }
    }

    public MemberImpl[] getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        Object key = this.getProperty("key");
        if (key != null) {
            return key.toString();
        }
        if (this.name == null && this.isAll()) {
            return this.getHierarchy().getAllMemberName();
        }
        return this.name;
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            if (this.isAll()) {
                this.caption = this.getHierarchy().getAllMemberCaption();
            } else if (!this.isCalculated() && !this.isCalculatedInSchema() && !this.level.isInner() && this.level.getDimension().isTimeDimension()) {
                this.caption = Util.fixTimeMemberCaption(this);
                if (this.level.levelType == 4 || this.level.levelType == 3) {
                    String pname = null;
                    Member p = this;
                    while ((p = this.getParentMember()) != null) {
                        if (p.getLevel().getLevelType() != 2) continue;
                        pname = p.getCaption();
                        break;
                    }
                    if (pname != null) {
                        this.caption = String.valueOf(pname) + this.caption;
                    }
                }
            } else {
                this.caption = this.getName();
            }
        }
        return this.caption;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = this.parent == null ? UniqueNameUtil.makeUniqueName(this.getHierarchy(), this.getName()) : UniqueNameUtil.makeUniqueName(this.parent, this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public int getDepth() {
        return this.level.getDepth();
    }

    @Override
    public boolean isCalculatedInSchema() {
        return false;
    }

    @Override
    public Exp getExpression(boolean includeDesandant) throws OlapException {
        if (this.exp != null) {
            return this.exp;
        }
        if (includeDesandant && this.desendantHasExpression) {
            return this.getAggregationExp();
        }
        return null;
    }

    public Exp getAggregationExp() throws OlapException {
        if (this.aggExp == null) {
            this.aggExp = this.makeExp();
        }
        return this.aggExp;
    }

    private Exp makeExp() throws OlapException {
        DelegatingExpResolver expResolver = new DelegatingExpResolver();
        Exp children = new FunCall("Children", new Exp[]{new MemberExpr(this)}, Syntax.Property);
        children = children.resolve(expResolver);
        Exp aggregate = new FunCall("Aggregate", new Exp[]{children}, Syntax.Function);
        aggregate = aggregate.resolve(expResolver);
        return aggregate;
    }

    @Override
    public void setExpression(Exp exp) {
        this.setExpression(exp, LeafFeature.ALL);
    }

    @Override
    public void setExpression(Exp exp, LeafFeature leafFeature) {
        this.exp = exp;
        this.leafFeature = leafFeature;
        if (this.parent != null) {
            this.parent.setDesendantHasExpression(true);
        }
    }

    public void setDesendantHasExpression(boolean recurse) {
        this.desendantHasExpression = true;
        if (recurse && this.parent != null) {
            this.parent.setDesendantHasExpression(true);
        }
    }

    @Override
    public boolean isDesendantHasExpression() {
        return this.desendantHasExpression;
    }

    @Override
    public boolean hasData() {
        return this.isMeasure() || this.isCalculated() || this.isInner() || this.isInnerCountMeasure() || this.hasData.hasData;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    public void setVisible(boolean b) {
        this.setProperty("visible", b);
    }

    @Override
    public boolean isVisible() {
        Object o = this.getProperty("visible");
        if (o != null && "false".equalsIgnoreCase(o.toString())) {
            return false;
        }
        Member parent = this.getParentMember();
        if (parent == null) {
            return true;
        }
        return this.getParentMember().isVisible();
    }

    @Override
    public boolean isInnerCountMeasure() {
        return false;
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    public void setHasSelfData(boolean b) {
        this.hasSelfData = b;
        if (this.parent != null) {
            this.parent.setChildrenHasSelfData(this.hasData.hasData);
        }
    }

    @Override
    public boolean hasSelfData() {
        return this.hasSelfData;
    }

    public void setChildrenHasSelfData(boolean b) {
        this.childrenHasSelfData = b;
        if (this.parent != null) {
            this.parent.setChildrenHasSelfData(this.hasData.hasData);
        }
    }

    @Override
    public boolean childrenHasSelfData() {
        return this.childrenHasSelfData;
    }

    @Override
    public int getPriorCellCalculationIndex() {
        return this.cellCalculationIndex;
    }

    @Override
    public void setPriorCellCalculationIndex(int index) {
        this.cellCalculationIndex = index;
    }

    @Override
    public IntBitSet getFilterBitSet() {
        return this.filterBitSet;
    }

    @Override
    public Calc getCalc() {
        return this.calc;
    }

    @Override
    public void setCalc(Calc calc) {
        this.calc = calc;
    }

    public void addScopedCalc(MemberScope scope, Calc calc, LeafFeature leafFeature) {
        if (this.scopedCalcList == null) {
            this.scopedCalcList = new ArrayList<ScopedCalc>();
        }
        this.scopedCalcList.add(new ScopedCalc((MemberScopeImpl)scope, calc, leafFeature));
        if (this.parent != null) {
            this.parent.setDesendantHasExpression(true);
        }
    }

    public Calc getCalc(Member[] members, EvaluatorImpl evaluator, boolean includeDesandant, boolean leaf) {
        if (this.exp != null && (this.leafFeature == null || this.leafFeature.contains(leaf))) {
            if (this.calc == null) {
                this.calc = evaluator.getContext().compileExpression(this.exp, true);
            }
            return this.calc;
        }
        if (this.scopedCalcList != null) {
            for (ScopedCalc sc : this.scopedCalcList) {
                Calc result;
                if (sc.leafFeature != null && !sc.leafFeature.contains(leaf) || (result = sc.validate(members, evaluator)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public boolean maybeNeedCalc() {
        return this.desendantHasExpression || this.calc != null || this.exp != null || this.scopedCalcList != null;
    }

    @Override
    public boolean hasCalc(boolean includeDesandant) {
        Exp exp = this.getExpression(includeDesandant);
        return exp != null || this.calc != null || this.scopedCalcList != null;
    }

    public List<MemberScopeImpl> getMemberScopes() {
        if (this.scopedCalcList != null) {
            ArrayList<MemberScopeImpl> result = new ArrayList<MemberScopeImpl>(2);
            for (ScopedCalc sc : this.scopedCalcList) {
                result.add(sc.scope);
            }
            return result;
        }
        return null;
    }
}

