/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.MemberScope;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.EvaluateContext;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.util.BitSetFactory;
import kd.bos.algo.olap.util.IntBitSet;
import kd.bos.algo.olap.util.Pair;

public class MemberScopeImpl
implements MemberScope {
    private String name;
    private List<Pair<String, String>> list;
    private Map<String, String> map;
    private int[] bindexes;
    private IntBitSet[] bitSets;
    private DimensionImpl[] dims;
    private HashSet<Member>[] dimMembers;

    public MemberScopeImpl(String name) {
        this.name = name;
        this.list = new ArrayList<Pair<String, String>>();
    }

    public MemberScopeImpl(String name, List<Pair<String, String>> list) {
        this.name = name;
        this.list = list;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Pair<String, String>> getMemberExpressions() {
        return this.list;
    }

    public void addPair(String dimension, String expression) {
        if (this.map == null) {
            this.map = new HashMap<String, String>();
            this.map.put(dimension, expression);
        } else if (this.map.put(dimension, expression) != null) {
            throw new OlapException("Dimension " + dimension + " already exist in member sope:" + this.name);
        }
        this.list.add(new Pair<String, String>(dimension, expression));
    }

    public boolean validate(Member[] members, Evaluator evaluator) {
        if (this.bitSets == null) {
            this.build(evaluator);
        }
        int i = 0;
        while (i < this.bindexes.length) {
            if (!this.bitSets[i].get(members[this.bindexes[i]].getGlobalOrder())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public DimensionImpl[] getDims() {
        return this.dims;
    }

    public HashSet<Member>[] getDimMembers() {
        return this.dimMembers;
    }

    public void build(Evaluator evaluator) {
        EvaluateContext ec = evaluator.getContext();
        Cube cube = ec.getSchemaReader().getCube();
        int size = this.list.size();
        this.bindexes = new int[size];
        this.bitSets = new IntBitSet[size];
        this.dims = new DimensionImpl[size];
        this.dimMembers = new HashSet[size];
        int pos = 0;
        for (Pair<String, String> pair : this.list) {
            MemberImpl member;
            String dimName = pair.getValue0();
            this.bindexes[pos] = cube.getDimensionOrdinal(dimName);
            this.bitSets[pos] = BitSetFactory.createIntBitSet();
            this.dims[pos] = (DimensionImpl)cube.getDimension(dimName);
            this.dimMembers[pos] = new HashSet();
            String expression = pair.getValue1();
            Exp exp = ec.parseExpression(expression, true);
            Calc calc = ec.compileExpression(exp, false);
            Object value = calc.evaluate(evaluator);
            if (value instanceof IList) {
                Iterator iter = ((IList)value).iterator();
                while (iter.hasNext()) {
                    member = (MemberImpl)iter.next();
                    if (member.isCalculated()) {
                        throw new OlapException("Calculated member not support in scope: " + member.getUniqueName());
                    }
                    this.bitSets[pos].set(member.getGlobalOrder());
                    member.setHasData(true);
                    this.dimMembers[pos].add(member);
                }
            } else if (value instanceof Member) {
                member = (MemberImpl)value;
                if (member.isCalculated()) {
                    throw new OlapException("Calculated member not support in scope: " + member.getUniqueName());
                }
                this.bitSets[pos].set(member.getGlobalOrder());
                member.setHasData(true);
                this.dimMembers[pos].add(member);
            }
            ++pos;
        }
    }
}

