/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.algo.olap.LeafFeature;
import kd.bos.algo.olap.MemberScope;
import kd.bos.algo.olap.MemberScopeBuilder;
import kd.bos.algo.olap.MetadataAPI;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.MemberScopeImpl;
import kd.bos.algo.olap.impl.ScopeBuilderImpl;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.calc.Calc;

public class MetadataAPIImpl
implements MetadataAPI {
    private SchemaReader schemaReader;
    private HashMap<String, MemberScope> scopeMap = new HashMap();
    private DimensionImpl calcDimension = null;

    public MetadataAPIImpl(SchemaReader schemaReader) {
        this.schemaReader = schemaReader;
    }

    @Override
    public MemberScopeBuilder getMemberScopeBuilder() {
        return new ScopeBuilderImpl();
    }

    @Override
    public void addMemberWeight(String uniqueName, int weight) {
        MemberImpl member = (MemberImpl)this.schemaReader.getMemberByUniqueName(uniqueName);
        member.setWeight(weight);
    }

    @Override
    public void addMemberWeight(String uniqueName, BigDecimal weight) {
        MemberImpl member = (MemberImpl)this.schemaReader.getMemberByUniqueName(uniqueName);
        member.setWeight(weight);
    }

    @Override
    public void addDefaultMemberExpression(String uniqueName, String expression, LeafFeature leafFeature) {
        MemberImpl member = (MemberImpl)this.schemaReader.getMemberByUniqueName(uniqueName);
        Exp exp = this.schemaReader.parseExpression(expression, true);
        member.setExpression(exp, leafFeature);
        Calc calc = this.schemaReader.compileExpression(exp, true);
        member.setCalc(calc);
        DimensionImpl dim = (DimensionImpl)member.getDimension();
        if (this.calcDimension == null) {
            this.calcDimension = dim;
        } else if (this.calcDimension != dim) {
            throw new OlapException("Olap support one dimension has member expression.");
        }
        switch (leafFeature) {
            case ALL: {
                dim.putCalcMemberOfAll(member);
                break;
            }
            case LEAF: {
                dim.putCalcMemberOfLeaf(member);
                break;
            }
            case NOTLEAF: {
                dim.putCalcMemberOfNotLeaf(member);
            }
        }
    }

    @Override
    public void addScopedMemberExpression(String uniqueName, String scopeName, String expression, LeafFeature leafFeature) {
        MemberScope scope = this.scopeMap.get(scopeName);
        if (scope == null) {
            throw new OlapException("Scope not found: " + scopeName);
        }
        MemberImpl member = (MemberImpl)this.schemaReader.getMemberByUniqueName(uniqueName);
        Exp exp = this.schemaReader.parseExpression(expression, true);
        Calc calc = this.schemaReader.compileExpression(exp, true);
        member.addScopedCalc(scope, calc, leafFeature);
        DimensionImpl dim = (DimensionImpl)member.getDimension();
        if (this.calcDimension == null) {
            this.calcDimension = dim;
        } else if (this.calcDimension != dim) {
            throw new OlapException("Olap support one dimension has member expression.");
        }
        switch (leafFeature) {
            case ALL: {
                dim.putCalcMemberOfAll(member);
                break;
            }
            case LEAF: {
                dim.putCalcMemberOfLeaf(member);
                break;
            }
            case NOTLEAF: {
                dim.putCalcMemberOfNotLeaf(member);
            }
        }
    }

    @Override
    public void addMemberSope(MemberScope scope) {
        if (this.scopeMap.put(scope.getName(), scope) != null) {
            throw new OlapException("scope " + scope.getName() + " already exists.");
        }
    }

    @Override
    public void addMemberScope(String name, String dimension, String expression) {
        MemberScope scope = this.scopeMap.get(name);
        if (scope == null) {
            scope = new MemberScopeImpl(name);
            this.scopeMap.put(scope.getName(), scope);
        }
        MemberScopeImpl scope2 = (MemberScopeImpl)scope;
        scope2.addPair(dimension, expression);
    }
}

