/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.MemberExpression;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.def.CalculatedMemberDef;
import kd.bos.algo.olap.def.ConditionalExpressionDef;
import kd.bos.algo.olap.def.CubeDef;
import kd.bos.algo.olap.def.DimensionUsageDef;
import kd.bos.algo.olap.def.HierarchyDef;
import kd.bos.algo.olap.def.LevelDef;
import kd.bos.algo.olap.def.MeasureDef;
import kd.bos.algo.olap.def.MemberExpressionDef;
import kd.bos.algo.olap.def.PartitionDef;
import kd.bos.algo.olap.def.PropertyDef;
import kd.bos.algo.olap.def.RelationDef;
import kd.bos.algo.olap.def.SchemaDef;
import kd.bos.algo.olap.def.SharedDimensionDef;
import kd.bos.algo.olap.impl.CalculatedMemberImpl;
import kd.bos.algo.olap.impl.CubeImpl;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.HierarchyImpl;
import kd.bos.algo.olap.impl.LevelImpl;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.PartitionImpl;
import kd.bos.algo.olap.impl.PropertyImpl;
import kd.bos.algo.olap.impl.RelationImpl;
import kd.bos.algo.olap.impl.SchemaImpl;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.Formula;
import kd.bos.algo.olap.mdx.Literal;
import kd.bos.algo.olap.mdx.MemberProperty;
import kd.bos.algo.olap.mdx.ParserHelp;
import kd.bos.algo.olap.util.Util;

public class SchemaBuilder {
    public static SchemaImpl buildSchema(SchemaDef def) throws OlapException {
        SchemaImpl schema = new SchemaImpl();
        schema.setProperty("name", def.name);
        schema.setProperty("caption", def.caption);
        schema.setProperty("description", def.description);
        schema.dims = null;
        schema.dims = def.dimensions == null ? new DimensionImpl[0] : new DimensionImpl[def.dimensions.length];
        int i = 0;
        while (i < schema.dims.length) {
            schema.dims[i] = SchemaBuilder.buildSharedDimension(schema, def.dimensions[i]);
            ++i;
        }
        i = 0;
        while (i < schema.dims.length) {
            String dependon = (String)schema.dims[i].getProperty("dependOnDimension");
            if (dependon != null) {
                schema.dims[i].setProperty("dependOnDimension", schema.getDimension(dependon));
            }
            ++i;
        }
        if (def.relations != null) {
            schema.relations = new RelationImpl[def.relations.length];
            i = 0;
            while (i < schema.relations.length) {
                schema.relations[i] = SchemaBuilder.buildRelation(schema, def.relations[i]);
                ++i;
            }
        }
        if (def.partition != null) {
            schema.partition = SchemaBuilder.buildPartition(schema, def.partition);
        }
        schema.cubes = new CubeImpl[def.cubes.length];
        i = 0;
        while (i < schema.cubes.length) {
            schema.cubes[i] = SchemaBuilder.buildCube(schema, def.cubes[i]);
            ++i;
        }
        return schema;
    }

    private static PartitionImpl buildPartition(SchemaImpl schema, PartitionDef partition) throws OlapException {
        String[] parts = partition.dimensions.split(",");
        if (parts.length != 1) {
            throw new OlapException("Only one partition dimensions supported now.");
        }
        Dimension dim = schema.getDimension(parts[0]);
        if (dim == null) {
            throw new OlapException("Partition dimension " + parts[0] + " not found.");
        }
        if (dim.getDimensionType() != 0 || dim.getHierarchy().getLevels().length != 1 || dim.isParentChildrenDimension()) {
            throw new OlapException("Partition dimension only support one level Standard Dimension.");
        }
        return new PartitionImpl(dim);
    }

    private static RelationImpl buildRelation(SchemaImpl schema, RelationDef relationDef) throws OlapException {
        RelationImpl rel = new RelationImpl();
        rel.name = relationDef.name;
        String[] parts = relationDef.dimensions.split(",");
        Dimension[] dims = new Dimension[parts.length];
        int i = 0;
        while (i < parts.length) {
            dims[i] = schema.getDimension(parts[i].trim());
            if (dims[i] == null) {
                throw new OlapException("Dimension " + parts[i] + " not found.");
            }
            ++i;
        }
        rel.setDimensions(dims);
        return rel;
    }

    private static DimensionImpl buildSharedDimension(SchemaImpl schema, SharedDimensionDef x) throws OlapException {
        DimensionImpl dim = new DimensionImpl();
        dim.setProperty("name", x.name);
        dim.setProperty("caption", x.caption);
        dim.setProperty("description", x.description);
        dim.setProperty("table", x.table);
        dim.setProperty("sql", x.sql);
        dim.setProperty("type", x.type);
        dim.setProperty("primaryKey", x.primaryKey);
        dim.dimensionType = x.type != null && x.type.equalsIgnoreCase("Time") ? (byte)1 : 0;
        dim.hies = new HierarchyImpl[x.hierarchies.length];
        int i = 0;
        while (i < dim.hies.length) {
            dim.hies[i] = SchemaBuilder.buildHierarchy(i, dim, x.hierarchies[i]);
            ++i;
        }
        dim.setProperty("Permission", x.permission);
        dim.setProperty("dependOnDimension", x.dependOnDimension);
        return dim;
    }

    private static HierarchyImpl buildHierarchy(int ordinal, DimensionImpl dim, HierarchyDef x) throws OlapException {
        HierarchyImpl hie = new HierarchyImpl(dim, x.name, x.caption);
        hie.ordinal = ordinal;
        hie.setProperty("description", x.description);
        hie.setProperty("hasAll", x.hasAll);
        hie.setProperty("allMemberName", x.allMemberName);
        hie.setProperty("allMemberCaption", x.allMemberCaption);
        hie.setProperty("virtualAllMemberCaption", x.v$AllMemberCaption);
        hie.levels = new LevelImpl[x.levels.length];
        int i = 0;
        while (i < hie.levels.length) {
            hie.levels[i] = SchemaBuilder.buildLevel(hie, x.levels[i]);
            ++i;
        }
        i = 0;
        while (i < hie.levels.length) {
            if (i > 0) {
                hie.levels[i].parent = hie.levels[i - 1];
            }
            if (i < hie.levels.length - 1) {
                hie.levels[i].child = hie.levels[i + 1];
            }
            hie.levels[i].depth = x.hasAll ? (byte)(i + 1) : (byte)i;
            ++i;
        }
        return hie;
    }

    private static LevelImpl buildLevel(HierarchyImpl hie, LevelDef x) throws OlapException {
        LevelImpl level = new LevelImpl();
        level.hie = hie;
        level.setProperty("name", x.name);
        level.setProperty("caption", x.caption);
        level.setProperty("description", x.description);
        level.setProperty("type", x.type);
        level.levelType = x.type == null ? (byte)0 : Util.getLevelType(x.type);
        level.setProperty("column", x.column);
        level.setProperty("orderBy", x.orderBy);
        level.setProperty("parentColumn", x.parentColumn);
        level.setProperty("childColumn", x.childColumn);
        level.setProperty("dataType", x.dataType);
        level.setProperty("closureDataType", x.closureDataType);
        level.setProperty("rule", x.rule);
        level.props = new PropertyImpl[x.properties.length];
        int i = 0;
        while (i < level.props.length) {
            level.props[i] = SchemaBuilder.buildProperty(x.properties[i]);
            ++i;
        }
        if (x.parentColumn != null) {
            hie.dim.isParentChildren = true;
        }
        return level;
    }

    private static PropertyImpl buildProperty(PropertyDef x) {
        PropertyImpl p = new PropertyImpl();
        p.setProperty("name", x.name);
        p.setProperty("caption", x.caption);
        p.setProperty("description", x.description);
        p.setProperty("column", x.column);
        p.setProperty("dataType", x.dataType);
        return p;
    }

    private static CubeImpl buildCube(SchemaImpl schema, CubeDef x) throws OlapException {
        CubeImpl cube = new CubeImpl(x);
        cube.schema = schema;
        cube.setProperty("name", x.name);
        cube.setProperty("caption", x.caption);
        cube.setProperty("description", x.description);
        cube.setProperty("table", x.table);
        cube.initMeasures(x);
        cube.dims = new DimensionImpl[x.dimensions.length];
        int i = 0;
        while (i < cube.dims.length) {
            if (x.dimensions[i] instanceof DimensionUsageDef) {
                cube.dims[i] = SchemaBuilder.buildDimensionUsage((DimensionImpl)schema.getDimension(x.dimensions[i].name), (DimensionUsageDef)x.dimensions[i]);
            }
            ++i;
        }
        DimensionImpl md = cube.measureDimension;
        cube.measures = new MemberImpl[x.measures.length];
        int i2 = 0;
        while (i2 < cube.measures.length) {
            MemberImpl measure;
            cube.measures[i2] = measure = SchemaBuilder.buildMeasure(cube, x.measures[i2]);
            measure.globalOrder = i2;
            measure.ordinal = i2;
            md.mapOrderToMember.put(i2, measure);
            ++i2;
        }
        md.memberCount = cube.measures.length;
        cube.measureHierarchy.setMembers(cube.measures);
        if (x.calculatedMembers == null) {
            cube.calculatedMembers = new CalculatedMemberImpl[0];
        } else {
            cube.calculatedMembers = new CalculatedMemberImpl[x.calculatedMembers.length];
            i2 = 0;
            while (i2 < x.calculatedMembers.length) {
                cube.calculatedMembers[i2] = SchemaBuilder.buildCalculatedMember(cube, x.calculatedMembers[i2]);
                ++i2;
            }
        }
        if (x.memberExpressions == null) {
            cube.memberExpressions = new MemberExpression[0];
        } else {
            cube.memberExpressions = new MemberExpression[x.memberExpressions.length];
            i2 = 0;
            while (i2 < x.memberExpressions.length) {
                cube.memberExpressions[i2] = SchemaBuilder.buildMemberExpression(cube, x.memberExpressions[i2]);
                ++i2;
            }
        }
        return cube;
    }

    private static MemberExpression buildMemberExpression(CubeImpl cube, MemberExpressionDef memberExpressionDef) {
        List<ConditionalExpressionDef> list;
        MemberExpression me = new MemberExpression(memberExpressionDef.getUniqueName());
        if (memberExpressionDef.getExpressionDef() != null) {
            me.setExpression(memberExpressionDef.getExpressionDef().getText());
        }
        if ((list = memberExpressionDef.getConditionalExpressionList()) != null) {
            for (ConditionalExpressionDef ce : list) {
                me.addConditionalExpression(ce.getCondition().getText(), ce.getExpression().getText());
            }
        }
        return me;
    }

    private static CalculatedMemberImpl buildCalculatedMember(CubeImpl cube, CalculatedMemberDef def) throws OlapException {
        String[] uniqueName = new String[]{def.dimension, def.name};
        Exp exp = ParserHelp.parseExpression(def.formula);
        ArrayList<MemberProperty> jlist = new ArrayList<MemberProperty>();
        if (def.formatString != null) {
            jlist.add(new MemberProperty("formatString", Literal.createString(def.formatString)));
        }
        if (def.color != null) {
            jlist.add(new MemberProperty("color", Literal.createString(def.color)));
        }
        if (def.bgColor != null) {
            jlist.add(new MemberProperty("bgColor", Literal.createString(def.bgColor)));
        }
        if (def.trend != null) {
            jlist.add(new MemberProperty("trend", Literal.createString(def.trend)));
        }
        if (def.status != null) {
            jlist.add(new MemberProperty("status", Literal.createString(def.status)));
        }
        if (def.solveOrder != null) {
            jlist.add(new MemberProperty("SOLVE_ORDER", Literal.create(Integer.valueOf(def.solveOrder))));
        }
        if (def.caption != null) {
            jlist.add(new MemberProperty("caption", Literal.createString(def.caption)));
        }
        if (!def.visible) {
            jlist.add(new MemberProperty("visible", Literal.createString("false")));
        }
        if (def.properties != null) {
            int i = 0;
            while (i < def.properties.length) {
                jlist.add(new MemberProperty(def.properties[i].name, Literal.createString(def.properties[i].value)));
                ++i;
            }
        }
        MemberProperty[] properties = new MemberProperty[jlist.size()];
        jlist.toArray(properties);
        Formula formula = new Formula(uniqueName, exp, properties, null);
        Dimension dim = cube.getDimension(def.dimension);
        CalculatedMemberImpl m = (CalculatedMemberImpl)dim.getDefaultHierarchy().createMember(def.name, def.caption, formula, true);
        formula.setMember(m);
        return m;
    }

    private static DimensionImpl buildDimensionUsage(DimensionImpl source, DimensionUsageDef x) throws OlapException {
        source.setProperty("foreignKey", x.foreignKey);
        return source;
    }

    private static MemberImpl buildMeasure(CubeImpl cube, MeasureDef x) {
        MemberImpl measure = new MemberImpl();
        if (x.name.equals("V$COUNTMEASURE")) {
            measure = (MemberImpl)cube.measureHierarchy.lookupInnerMember(x.name);
            measure.setProperty("caption", x.caption);
            return measure;
        }
        measure.memberType = (byte)2;
        measure.level = cube.measureLevel;
        measure.setProperty("name", x.name);
        measure.setProperty("caption", x.caption);
        measure.setProperty("description", x.description);
        measure.setProperty("column", x.column);
        measure.setProperty("aggregator", x.aggregator);
        measure.setProperty("formatString", x.formatString);
        measure.setProperty("color", x.color);
        measure.setProperty("bgColor", x.bgColor);
        measure.setProperty("trend", x.trend);
        measure.setProperty("status", x.status);
        measure.setProperty("visible", x.visible);
        if (x.properties != null) {
            int i = 0;
            while (i < x.properties.length) {
                measure.setProperty(x.properties[i].name, x.properties[i].value);
                ++i;
            }
        }
        return measure;
    }
}

