/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.DefaultListFactory;
import kd.bos.algo.olap.collection.IMemberList;
import kd.bos.algo.olap.impl.CalculatedMemberImpl;
import kd.bos.algo.olap.impl.CubeImpl;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.LevelImpl;
import kd.bos.algo.olap.impl.SchemaImpl;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ParserHelp;
import kd.bos.algo.olap.mdx.SchemaLookup;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.StackExpResolver;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.impl.BetterScalarExpCompiler;
import kd.bos.algo.olap.util.UniqueNameUtil;

public class SchemaReaderImpl
implements SchemaReader,
Serializable {
    private static final long serialVersionUID = 3477544633511420007L;
    SchemaImpl schema;
    private BetterScalarExpCompiler compiler;
    private StackExpResolver resolver;

    public SchemaReaderImpl(SchemaImpl schema) {
        this.schema = schema;
        this.resolver = new StackExpResolver(this);
        this.compiler = new BetterScalarExpCompiler(this.resolver);
    }

    @Override
    public Cube[] getCubes() {
        return this.schema.getCubes();
    }

    @Override
    public Cube getCube(String cubeName) {
        return this.schema.getCube(cubeName);
    }

    @Override
    public OlapElement getElementChild(OlapElement parent, String name) throws OlapException {
        return parent.lookupChild(this, name);
    }

    @Override
    public Member getHierarchyDefaultMember(Hierarchy hierarchy) {
        return hierarchy.getDefaultMember();
    }

    public Level[] getHierarchyLevels(Hierarchy hierarchy) {
        return hierarchy.getLevels();
    }

    @Override
    public IMemberList getHierarchyRootMembers(Hierarchy hierarchy) {
        return hierarchy.getMembers();
    }

    @Override
    public Member getLeadMember(Member member, int n) throws OlapException {
        Member nr = member.getHierarchy().getNullMember();
        if (member.isNull()) {
            return nr;
        }
        Member parent = member.getParentMember();
        int index = member.getOrdinal() + n;
        if (parent == null) {
            if (index < 0) {
                return nr;
            }
            IMemberList ms = this.getLevelMembers(member.getLevel());
            if (index >= ms.size()) {
                return nr;
            }
            Member _member = (Member)ms.get(index);
            if (member.getDimension().getName().equalsIgnoreCase("period") && _member.getName().startsWith(member.getName().substring(0, 4))) {
                return _member;
            }
            return nr;
        }
        while (true) {
            if (index >= 0) {
                IMemberList ms = parent.getChildMembers();
                if (index >= ms.size()) {
                    if ((parent = this.getLeadMember(parent, 1)).isNull()) break;
                    index -= ms.size();
                    continue;
                }
                return (Member)ms.get(index);
            }
            if ((parent = this.getLeadMember(parent, -1)).isNull()) break;
            index = parent.getChildMembers().size() + index;
        }
        return nr;
    }

    @Override
    public IMemberList getLevelMembers(Level level) {
        return ((LevelImpl)level).getMemberList();
    }

    @Override
    public int getLevelMemberCount(Level level) {
        IMemberList list = this.getLevelMembers(level);
        return list.size();
    }

    @Override
    public Member getMemberByUniqueName(String uniqueName) throws OlapException {
        return this.getMemberByUniqueName(this.schema.getCube(), uniqueName);
    }

    @Override
    public Member getMemberByUniqueName(Cube cube, String uniqueName) throws OlapException {
        String[] nameParts = UniqueNameUtil.explode(uniqueName);
        Member member = (Member)this.lookupCompound(cube, nameParts, 6);
        if (member == null) {
            throw new OlapException("Member " + uniqueName + " not found.");
        }
        return member;
    }

    @Override
    public IMemberList getMemberChildren(Member member) {
        return member.getChildMembers();
    }

    @Override
    public IMemberList getMemberChildren(IMemberList members) {
        IMemberList list = DefaultListFactory.instance.createMemberList();
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            list.addList(this.getMemberChildren((Member)iter.next()));
        }
        return list;
    }

    @Override
    public int getMemberDepth(Member member) {
        return member.getLevel().getDepth();
    }

    @Override
    public Member getMemberParent(Member member) {
        return member.getParentMember();
    }

    @Override
    public void getMemberRange(Level level, Member startMember, Member endMember, IMemberList list) throws OlapException {
        list.add(startMember);
        if (!startMember.equals(endMember)) {
            IMemberList ms = this.getLevelMembers(startMember.getLevel());
            boolean notstart = true;
            Iterator iter = ms.iterator();
            while (iter.hasNext()) {
                Member m = (Member)iter.next();
                if (notstart) {
                    if (!m.equals(startMember)) continue;
                    notstart = false;
                    continue;
                }
                list.add(m);
                if (m.equals(endMember)) break;
            }
        }
    }

    @Override
    public OlapElement lookupCompound(OlapElement parent, String[] names, int category) throws OlapException {
        return SchemaLookup.lookupCompound(this, parent, names, category);
    }

    @Override
    public Member getCalculatedMember(Cube cube, String uniqueName) {
        CubeImpl cubeX = (CubeImpl)cube;
        CalculatedMemberImpl[] members = cubeX.calculatedMembers;
        if (members != null && members.length > 0) {
            int i = 0;
            while (i < members.length) {
                if (uniqueName.equalsIgnoreCase(members[i].getUniqueName())) {
                    return members[i];
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Member[] getCalculatedMembers(Cube cube, Hierarchy hierarchy) {
        CubeImpl cubeX = (CubeImpl)cube;
        CalculatedMemberImpl[] members = cubeX.calculatedMembers;
        ArrayList<CalculatedMemberImpl> jlist = new ArrayList<CalculatedMemberImpl>();
        if (members != null && members.length > 0) {
            int i = 0;
            while (i < members.length) {
                if (members[i].getHierarchy().equals(hierarchy)) {
                    jlist.add(members[i]);
                }
                ++i;
            }
        }
        return jlist.toArray(new Member[0]);
    }

    @Override
    public boolean isDrillable(Member member) {
        return !member.isLeaf();
    }

    @Override
    public void getDescendants(Member member, IMemberList result) throws OlapException {
        this.getHierarchizeMembers(result, member.getChildMembers());
    }

    @Override
    public void getLeafDescendants(Member member, IMemberList result) throws OlapException {
        this.getLeafHierarchizeMembers(result, member.getChildMembers());
    }

    @Override
    public void getNotLeafDescendants(Member member, IMemberList result) throws OlapException {
        this.getNotLeafHierarchizeMembers(result, member.getChildMembers());
    }

    @Override
    public void getMemberDescendants(Member member, IMemberList result, Level level, boolean before, boolean self, boolean after) {
        byte levelDepth = level.getDepth();
        IMemberList members = DefaultListFactory.instance.createMemberList();
        members.add(member);
        IMemberList fertileMembers = DefaultListFactory.instance.createMemberList();
        do {
            fertileMembers = DefaultListFactory.instance.createMemberList();
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                member = (Member)iter.next();
                byte currentDepth = member.getLevel().getDepth();
                if (currentDepth == levelDepth) {
                    if (self) {
                        result.add(member);
                    }
                    if (!after) continue;
                    fertileMembers.add(member);
                    continue;
                }
                if (currentDepth < levelDepth) {
                    if (before) {
                        result.add(member);
                    }
                    fertileMembers.add(member);
                    continue;
                }
                if (!after) continue;
                result.add(member);
                fertileMembers.add(member);
            }
            members = DefaultListFactory.instance.createMemberList();
            iter = fertileMembers.iterator();
            while (iter.hasNext()) {
                member = (Member)iter.next();
                IMemberList ms = this.getMemberChildren(member);
                members.addList(ms);
            }
        } while (members.size() > 0);
    }

    @Override
    public int getMemberCount(Hierarchy hierarchy) throws OlapException {
        return this.getHierarchyMembers(hierarchy, false).size();
    }

    @Override
    public IMemberList getHierarchyMembers(Hierarchy hierarchy, boolean hierarchize) throws OlapException {
        IMemberList members = DefaultListFactory.instance.createMemberList();
        IMemberList ms = this.getHierarchyRootMembers(hierarchy);
        members = this.getHierarchizeMembers(members, ms);
        return members;
    }

    private IMemberList getHierarchizeMembers(IMemberList members, IMemberList ms) throws OlapException {
        if (ms.isEmpty()) {
            return members;
        }
        Iterator iter = ms.iterator();
        while (iter.hasNext()) {
            Member m = (Member)iter.next();
            members.add(m);
            members = this.getHierarchizeMembers(members, this.getMemberChildren(m));
        }
        return members;
    }

    private IMemberList getLeafHierarchizeMembers(IMemberList members, IMemberList ms) throws OlapException {
        if (ms.isEmpty()) {
            return members;
        }
        Iterator iter = ms.iterator();
        while (iter.hasNext()) {
            Member m = (Member)iter.next();
            if (m.isLeaf()) {
                members.add(m);
                continue;
            }
            members = this.getLeafHierarchizeMembers(members, this.getMemberChildren(m));
        }
        return members;
    }

    private IMemberList getNotLeafHierarchizeMembers(IMemberList members, IMemberList ms) throws OlapException {
        if (ms.isEmpty()) {
            return members;
        }
        Iterator iter = ms.iterator();
        while (iter.hasNext()) {
            Member m = (Member)iter.next();
            if (m.isLeaf()) continue;
            members.add(m);
            members = this.getNotLeafHierarchizeMembers(members, this.getMemberChildren(m));
        }
        return members;
    }

    @Override
    public Member[] getCalculatedMembers(Cube cube) throws OlapException {
        return ((CubeImpl)cube).getCalculatedMembers();
    }

    @Override
    public Cube getCube() {
        return this.schema.getCube();
    }

    @Override
    public Exp parseExpression(String expression, boolean resolve) {
        Exp exp = ParserHelp.parseExpression(expression);
        return resolve ? this.resolver.resolve(exp) : exp;
    }

    @Override
    public Calc compileExpression(Exp exp, boolean scalar) throws OlapException {
        if (scalar) {
            return this.compiler.compileScalar(exp, false);
        }
        return exp.compile(this.compiler);
    }

    @Override
    public OlapElement lookupByName(String name) {
        return this.schema.lookupGlobal(this, name);
    }

    @Override
    public Member getMemberByName(String dimName, String memberName) {
        DimensionImpl dim = (DimensionImpl)this.schema.getDimension(dimName);
        if (dim == null) {
            throw new OlapException("Dimension " + dimName + " not found.");
        }
        return dim.getMemberByName(memberName);
    }
}

