/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Member;

public class WeightCalculation {
    private int[] dimIndexes;
    private boolean hasWeight;
    private static Integer i0 = 0;
    private static Integer i1 = 1;
    private static BigDecimal d0 = new BigDecimal(0);
    private static BigDecimal d1 = new BigDecimal(1);

    public WeightCalculation(Cube cube) {
        this.init(cube);
    }

    public WeightCalculation(Member[] members) {
        this.init(members);
    }

    public boolean hasWeight() {
        return this.hasWeight;
    }

    private void init(Cube cube) {
        ArrayList<Integer> list = new ArrayList<Integer>(0);
        Dimension[] dims = cube.getDimensions();
        int i = 0;
        while (i < dims.length) {
            if (dims[i].hasWeight()) {
                list.add(i);
            }
            ++i;
        }
        if (list.size() > 0) {
            this.dimIndexes = new int[list.size()];
            i = 0;
            while (i < this.dimIndexes.length) {
                this.dimIndexes[i] = (Integer)list.get(i);
                ++i;
            }
            this.hasWeight = true;
        }
    }

    private void init(Member[] members) {
        ArrayList<Integer> list = new ArrayList<Integer>(0);
        int i = 0;
        while (i < members.length) {
            if (members[i].getDimension().hasWeight()) {
                list.add(i);
            }
            ++i;
        }
        if (list.size() > 0) {
            this.dimIndexes = new int[list.size()];
            i = 0;
            while (i < this.dimIndexes.length) {
                this.dimIndexes[i] = (Integer)list.get(i);
                ++i;
            }
            this.hasWeight = true;
        }
    }

    public Object calc(Object members, Object value) {
        if (members instanceof Member[]) {
            return this.calc((Member[])members, value);
        }
        return this.calc((Member)members, value);
    }

    public Object calc(Member member, Object value) {
        if (this.dimIndexes == null || value == null) {
            return value;
        }
        Number weight = member.getWeight();
        if (weight == null || i1.equals(weight) || d1.equals(weight)) {
            return value;
        }
        if (i0.equals(weight) || d0.equals(weight)) {
            return null;
        }
        BigDecimal bd = weight instanceof BigDecimal ? (BigDecimal)weight : BigDecimal.valueOf(weight.intValue());
        return ((BigDecimal)value).multiply(bd);
    }

    public Object calc(Member[] members, Object value, int index) {
        return this.calc(members[index], value);
    }

    public Object calc(Member[] members, Object value) {
        if (this.dimIndexes == null || value == null) {
            return value;
        }
        if (this.dimIndexes.length == 1) {
            Number weight = members[this.dimIndexes[0]].getWeight();
            if (weight == null || i1.equals(weight) || d1.equals(weight)) {
                return value;
            }
            if (i0.equals(weight) || d0.equals(weight)) {
                return null;
            }
            BigDecimal bd = weight instanceof BigDecimal ? (BigDecimal)weight : BigDecimal.valueOf(weight.intValue());
            return ((BigDecimal)value).multiply(bd);
        }
        BigDecimal bd = d1;
        int i = 0;
        while (i < this.dimIndexes.length) {
            Number weight = members[this.dimIndexes[i]].getWeight();
            if (weight != null && !i1.equals(weight) && !d1.equals(weight)) {
                if (i0.equals(weight) || d0.equals(weight)) {
                    return null;
                }
                bd = weight instanceof BigDecimal ? bd.multiply((BigDecimal)weight) : bd.multiply(BigDecimal.valueOf(weight.intValue()));
            }
            ++i;
        }
        return ((BigDecimal)value).multiply(bd);
    }

    public Object[] calc(Member[] members, Object[] values, int index) {
        if (this.dimIndexes == null || values == null || values.length == 1 && values[0] == null) {
            return values;
        }
        Number weight = members[index].getWeight();
        if (weight == null || i1.equals(weight) || d1.equals(weight)) {
            return values;
        }
        if (i0.equals(weight) || d0.equals(weight)) {
            return null;
        }
        BigDecimal bd = weight instanceof BigDecimal ? (BigDecimal)weight : BigDecimal.valueOf(weight.intValue());
        Object[] newValues = new Object[values.length];
        int i = 0;
        while (i < values.length) {
            newValues[i] = values[i] != null ? ((BigDecimal)values[i]).multiply(bd) : values[i];
            ++i;
        }
        return newValues;
    }
}

