/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx;

import java.io.Serializable;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.Syntax;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.type.Type;

public abstract class ExpBase
implements Exp,
Serializable {
    public static final long serialVersionUID = 4576383108127547547L;

    protected ExpBase() {
    }

    @Override
    public abstract Object clone();

    @Override
    public final boolean isSet() {
        int cat = this.getCategory();
        return cat == 8 || cat == 10;
    }

    @Override
    public final boolean isMember() {
        return this.getCategory() == 6;
    }

    @Override
    public final boolean isElement() {
        int category = this.getCategory();
        return this.isMember() || category == 3 || category == 4 || category == 2;
    }

    @Override
    public final boolean isEmptySet() {
        if (this instanceof FunCall) {
            FunCall f = (FunCall)this;
            return f.getSyntax() == Syntax.Braces && f.getArgCount() == 0;
        }
        return false;
    }

    public final Member[] isConstantTuple() {
        if (this instanceof Member) {
            return new Member[]{(Member)((Object)this)};
        }
        if (!(this instanceof FunCall)) {
            return null;
        }
        FunCall f = (FunCall)this;
        if (!f.isCallToTuple()) {
            return null;
        }
        int len = f.getArgCount();
        int i = 0;
        while (i < len) {
            if (!(f.getArg(i) instanceof Member)) {
                return null;
            }
            ++i;
        }
        Member[] members = new Member[len];
        System.arraycopy(f.getArgs(), 0, members, 0, len);
        return members;
    }

    public static int[] getCategorys(Exp[] exps) {
        int[] types = new int[exps.length];
        int i = 0;
        while (i < exps.length) {
            types[i] = exps[i].getCategory();
            ++i;
        }
        return types;
    }

    @Override
    public boolean dependsOn(Dimension dimension) {
        Type type = this.getType();
        return !type.usesDimension(dimension);
    }

    @Override
    public String toMdx() {
        StringBuilder sb = new StringBuilder();
        this.unparse(sb);
        return sb.toString();
    }

    @Override
    public void unparse(StringBuilder sb) {
        sb.append(this.toString());
    }

    public static void unparseList(StringBuilder sb, Exp[] exps, String start, String mid, String end) {
        sb.append(start);
        int i = 0;
        while (i < exps.length) {
            if (i > 0) {
                sb.append(mid);
            }
            exps[i].unparse(sb);
            ++i;
        }
        sb.append(end);
    }

    static Exp[] cloneArray(Exp[] a) {
        Exp[] a2 = new Exp[a.length];
        int i = 0;
        while (i < a.length) {
            a2[i] = (Exp)a[i].clone();
            ++i;
        }
        return a2;
    }

    @Override
    public Calc compile(ExpCompiler compiler) throws OlapException {
        throw new UnsupportedOperationException(this.toString());
    }
}

