/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.FunDef;
import kd.bos.algo.olap.mdx.FunFactory;
import kd.bos.algo.olap.mdx.FuncResolver;
import kd.bos.algo.olap.mdx.FunctionException;
import kd.bos.algo.olap.mdx.SimpleFuncResolver;
import kd.bos.algo.olap.mdx.Syntax;
import kd.bos.algo.olap.mdx.func.BaseFunFactory;
import kd.bos.algo.olap.util.IntHolder;

public class FunTable {
    public static FunTable instance = new FunTable();
    private final List resolvers = new ArrayList();
    private final HashSet reservedWords = new HashSet();
    private final HashSet propertyWords = new HashSet();
    private HashMap<String, ArrayList<FuncResolver>> mapNameToResolvers = new HashMap();
    private FunFactory[] funFactorys = new FunFactory[]{new BaseFunFactory(this)};

    private FunTable() {
        this.init();
    }

    private void init() {
        this.defineReserved("NULL");
        int i = 0;
        while (i < this.funFactorys.length) {
            this.funFactorys[i].defineFunctions();
            ++i;
        }
        i = 0;
        int n = this.resolvers.size();
        while (i < n) {
            FuncResolver resolver = (FuncResolver)this.resolvers.get(i);
            String key = FunTable.makeResolverKey(resolver.getName(), resolver.getSyntax());
            ArrayList<FuncResolver> v2 = this.mapNameToResolvers.get(key);
            if (v2 == null) {
                v2 = new ArrayList();
                this.mapNameToResolvers.put(key, v2);
            }
            v2.add(resolver);
            ++i;
        }
    }

    protected void define(FunDef funDef) {
        this.define(new SimpleFuncResolver(funDef));
    }

    protected void define(FuncResolver resolver) {
        if (resolver.getSyntax() == Syntax.Property) {
            this.defineProperty(resolver.getName());
        }
        this.resolvers.add(resolver);
        String[] reservedWords = resolver.getReservedWords();
        int i = 0;
        while (i < reservedWords.length) {
            String reservedWord = reservedWords[i];
            this.defineReserved(reservedWord);
            ++i;
        }
    }

    public boolean isReserved(String s) {
        return this.reservedWords.contains(s.toUpperCase());
    }

    protected void defineReserved(String s) {
        this.reservedWords.add(s.toUpperCase());
    }

    public boolean isProperty(String s) {
        return this.propertyWords.contains(s.toUpperCase());
    }

    protected void defineProperty(String s) {
        this.propertyWords.add(s.toUpperCase());
    }

    private static String makeResolverKey(String name, Syntax syntax) {
        return String.valueOf(name.toUpperCase()) + "$" + syntax;
    }

    public FunDef getDef(FunCall call) throws OlapException {
        String key = FunTable.makeResolverKey(call.getFunction(), call.getSyntax());
        ArrayList<FuncResolver> resolvers = this.mapNameToResolvers.get(key);
        if (resolvers == null || resolvers.isEmpty()) {
            throw new FunctionException("\u51fd\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u51fd\u6570\u540d\u4e0d\u5b58\u5728\u6216\u8005\u53c2\u6570\u7c7b\u578b\u9519\u8bef:\n" + call.toMdx());
        }
        IntHolder conversionCount = new IntHolder(0);
        int minConversions = Integer.MAX_VALUE;
        int matchCount = 0;
        FunDef matchDef = null;
        for (FuncResolver resolver : resolvers) {
            conversionCount.value = 0;
            FunDef def = resolver.resolve(call.getArgs(), conversionCount);
            if (def == null) continue;
            int conversions = conversionCount.value;
            if (conversions < minConversions) {
                minConversions = conversions;
                matchCount = 1;
                matchDef = def;
                continue;
            }
            if (conversions != minConversions) continue;
            ++matchCount;
        }
        switch (matchCount) {
            case 0: {
                throw new FunctionException("\u51fd\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u51fd\u6570\u540d\u4e0d\u5b58\u5728\u6216\u8005\u53c2\u6570\u7c7b\u578b\u9519\u8bef:\n" + call.toMdx());
            }
            case 1: {
                return matchDef;
            }
        }
        throw new FunctionException("\u53c2\u6570\u7c7b\u578b\u4e0d\u660e\u786e\uff0c\u5bfc\u81f4\u591a\u4e2a\u51fd\u6570\u5339\u914d:\n" + call.toMdx());
    }
}

