/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.olap.CalculatedMember;
import kd.bos.algo.olap.Connection;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.DefaultListFactory;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.collection.IListFactory;
import kd.bos.algo.olap.impl.BBFilterIndexWithMeasure;
import kd.bos.algo.olap.impl.CellReaderImpl;
import kd.bos.algo.olap.impl.ConnectionImpl;
import kd.bos.algo.olap.impl.CubeImpl;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.EvaluateContext;
import kd.bos.algo.olap.impl.EvaluatorImpl;
import kd.bos.algo.olap.impl.LinkCellReader;
import kd.bos.algo.olap.mdx.CacheType;
import kd.bos.algo.olap.mdx.DelegatingSchemaReader;
import kd.bos.algo.olap.mdx.DimensionProperty;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.Formula;
import kd.bos.algo.olap.mdx.Literal;
import kd.bos.algo.olap.mdx.MemberProperty;
import kd.bos.algo.olap.mdx.ParserHelp;
import kd.bos.algo.olap.mdx.QueryAxis;
import kd.bos.algo.olap.mdx.QueryObject;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.Set;
import kd.bos.algo.olap.mdx.StackExpResolver;
import kd.bos.algo.olap.mdx.calc.BooleanCalc;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.impl.BetterScalarExpCompiler;
import kd.bos.algo.olap.mdx.type.SetType;
import kd.bos.algo.olap.mdx.type.TupleType;
import kd.bos.algo.olap.mdx.type.Type;
import kd.bos.algo.olap.util.RoaringIntBitSet;
import kd.bos.algo.olap.util.RoaringLongBitSet;
import kd.bos.algo.olap.util.UniqueNameUtil;
import kd.bos.algo.olap.util.Util;
import org.roaringbitmap.IntIterator;

public class MdxQuery
extends QueryObject
implements EvaluateContext,
Serializable {
    List<Formula> formulas = new ArrayList<Formula>();
    ArrayList axisDef = null;
    String cubeName;
    transient Connection connection;
    List cellProps = new ArrayList();
    Exp slicer = null;
    private QueryAxis[] axes = null;
    private Calc[] axisCalcs = null;
    private Calc slicerCalc = null;
    private CellReaderImpl cellReader;
    private CubeImpl cube;
    public long useTime = 0L;
    private List<CellCalculationInfo> cellCalculations = null;
    CCFilters ccFilters;
    QuerySchemaReader schemaReader = null;
    IListFactory listFactory = null;
    private HashMap<String, LinkCellReader> linkCellReaderMap;

    public void afterParse(Connection cn) throws OlapException {
        if (this.axisDef != null) {
            this.axes = this.axisDef.toArray(new QueryAxis[0]);
            this.axisDef = null;
        }
        this.connection = cn;
        this.resolve();
        this.cube = (CubeImpl)this.getCube();
        this.cellReader = new CellReaderImpl(((ConnectionImpl)cn).getDatabase());
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public ExpResolver createExpResolver() throws OlapException {
        Cube cube = this.connection.getSchemaReader().getCube(this.cubeName);
        if (cube == null) {
            throw new OlapException("Cube named " + this.cubeName + " not found.");
        }
        StackExpResolver resolver = new StackExpResolver(this.getSchemaReader());
        return resolver;
    }

    private ExpCompiler createCompiler(ExpResolver resolver) {
        BetterScalarExpCompiler compiler = new BetterScalarExpCompiler(resolver);
        return compiler;
    }

    public void resolve() throws OlapException {
        ExpResolver resolver = this.createExpResolver();
        this.resolve(resolver);
        ExpCompiler compiler = this.createCompiler(resolver);
        this.compile(compiler);
    }

    public void resolve(ExpResolver resolver) throws OlapException {
        Cube cube;
        if (this.formulas != null) {
            Formula formula;
            int i = 0;
            while (i < this.formulas.size()) {
                formula = this.formulas.get(i);
                formula.createElement(resolver.getSchemaReader());
                ++i;
            }
            i = 0;
            while (i < this.formulas.size()) {
                formula = this.formulas.get(i);
                resolver.resolve(formula);
                ++i;
            }
        }
        if ((cube = this.getCube()).getCalculatedMembers() != null) {
            CalculatedMember[] members = cube.getCalculatedMembers();
            int i = 0;
            while (i < members.length) {
                resolver.resolve(members[i].getFormula());
                ++i;
            }
        }
        if (this.axes != null) {
            int i = 0;
            while (i < this.axes.length) {
                resolver.resolve(this.axes[i]);
                ++i;
            }
        }
        if (this.slicer != null) {
            this.slicer = this.slicer.resolve(resolver);
        }
    }

    @Override
    public Calc compileExpression(Exp exp, boolean scalar) throws OlapException {
        ExpResolver resolver = this.createExpResolver();
        ExpCompiler compiler = this.createCompiler(resolver);
        Calc calc = scalar ? compiler.compileScalar(exp, false) : exp.compile(compiler);
        return calc;
    }

    private int getDimensionIndexInCube(Dimension dim) {
        Cube cube = this.connection.getSchemaReader().getCubes()[0];
        Dimension[] dims = cube.getDimensions();
        int i = 0;
        while (i < dims.length) {
            if (dims[i].equals(dim)) {
                return i;
            }
            ++i;
        }
        return dims.length;
    }

    @Override
    public Evaluator createEvaluator() throws OlapException {
        return new EvaluatorImpl(this, this.cube, this.cellReader);
    }

    public java.util.Set getCellCalculationMemberSet(Evaluator evaluator) throws OlapException {
        if (this.cellCalculations == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Member> set = new HashSet<Member>();
        int i = this.cellCalculations.size() - 1;
        while (i >= 0) {
            CellCalculationInfo info = this.cellCalculations.get(i);
            if (info.list == null) {
                info.list = info.listCalc.evaluateList(evaluator);
            }
            Iterator iter = info.list.iterator();
            while (iter.hasNext()) {
                Member[] members = Util.toMemberArray(iter.next());
                int j = 0;
                while (j < members.length) {
                    set.add(members[j]);
                    ++j;
                }
            }
            --i;
        }
        return set;
    }

    @Override
    public Calc getCellCalculation(Evaluator evaluator) throws OlapException {
        if (this.cellCalculations == null || this.cellCalculations.isEmpty()) {
            return null;
        }
        if (this.ccFilters == null) {
            this.ccFilters = new CCFilters();
        }
        long st = System.currentTimeMillis();
        Calc calc = this.ccFilters.getCellCalculationInfo(evaluator);
        this.useTime = this.useTime + System.currentTimeMillis() - st;
        return calc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Calc getCellCalculation0(Evaluator evaluator) throws OlapException {
        if (this.cellCalculations == null || this.cellCalculations.isEmpty()) {
            return null;
        }
        Member[] context = evaluator.getCurrentMembers();
        int i = this.cellCalculations.size() - 1;
        while (i >= 0) {
            CellCalculationInfo info = this.cellCalculations.get(i);
            if (info.forAll) {
                if (info.conditionCalc == null) return info.calc;
                if (info.conditionCalc.evaluateBoolean(evaluator)) {
                    return info.calc;
                }
            } else {
                if (info.list == null) {
                    info.list = info.listCalc.evaluateList(evaluator);
                }
                Iterator iter = info.list.iterator();
                while (iter.hasNext()) {
                    Member[] members = Util.toMemberArray(iter.next());
                    if (!Util.tupleContains(context, members)) continue;
                    if (info.conditionCalc == null) return info.calc;
                    if (!info.conditionCalc.evaluateBoolean(evaluator)) continue;
                    return info.calc;
                }
            }
            --i;
        }
        return null;
    }

    private void compile(ExpCompiler compiler) throws OlapException {
        if (this.formulas != null && !this.formulas.isEmpty()) {
            for (Formula formula : this.formulas) {
                if (!formula.isCellCalculation()) continue;
                boolean forAll = false;
                ListCalc listCalc = null;
                BooleanCalc conditionCalc = null;
                if (formula.scope instanceof Literal && "all".equalsIgnoreCase(((Literal)formula.scope).toString())) {
                    forAll = true;
                } else {
                    listCalc = compiler.compileList(formula.scope);
                }
                Calc calc = compiler.compileScalar(formula.exp, true);
                Exp condition = formula.getCondition();
                if (condition != null) {
                    try {
                        conditionCalc = compiler.compileBoolean(condition);
                    }
                    catch (ClassCastException e) {
                        throw new OlapException("Cell Calculation Condition must be Boolean,but " + condition.toMdx() + " is not.", e);
                    }
                }
                if (this.cellCalculations == null) {
                    this.cellCalculations = new ArrayList<CellCalculationInfo>();
                }
                this.cellCalculations.add(new CellCalculationInfo(forAll, listCalc, calc, conditionCalc));
            }
        }
        if (this.axes != null) {
            this.axisCalcs = new Calc[this.axes.length];
            int i = 0;
            while (i < this.axes.length) {
                this.axisCalcs[i] = this.axes[i].compile(compiler);
                ++i;
            }
        }
        if (this.slicer != null) {
            this.slicerCalc = compiler.compile(this.slicer);
        }
    }

    @Override
    public SchemaReader getSchemaReader() {
        if (this.schemaReader == null) {
            this.schemaReader = new QuerySchemaReader(this.connection.getSchemaReader());
        }
        return this.schemaReader;
    }

    public Member lookupMemberFromDefined(String s) {
        for (Formula formula : this.formulas) {
            if (!formula.isMember() || !formula.getUniqeName().equalsIgnoreCase(s)) continue;
            return formula.getMember();
        }
        return null;
    }

    public QueryAxis[] getAxes() {
        return this.axes;
    }

    public QueryAxis getAxis(String name) {
        int i = 0;
        while (i < this.axes.length) {
            if (name.equalsIgnoreCase(this.axes[i].getName())) {
                return this.axes[i];
            }
            ++i;
        }
        return null;
    }

    public Calc getAxisCalc(String name) {
        int i = 0;
        while (i < this.axes.length) {
            if (name.equalsIgnoreCase(this.axes[i].getName())) {
                return this.axisCalcs[i];
            }
            ++i;
        }
        return null;
    }

    public void setAxes(QueryAxis[] axes) {
        this.axes = axes;
    }

    public Cube getCube() {
        return this.connection.getSchemaReader().getCube(this.cubeName);
    }

    public String getCubeName() {
        if (this.cubeName.charAt(0) == '[' && this.cubeName.charAt(this.cubeName.length() - 1) == ']') {
            return this.cubeName.substring(1, this.cubeName.length() - 1);
        }
        return this.cubeName;
    }

    public void setCubeName(String cubeName) {
        this.cubeName = cubeName;
    }

    public Formula[] getFormulas() {
        return this.formulas.toArray(new Formula[0]);
    }

    @Override
    public boolean hasFormulas() {
        return this.formulas.size() > 0;
    }

    public String toString() {
        try {
            this.resolve();
        }
        catch (OlapException olapException) {
            // empty catch block
        }
        return this.toMdx();
    }

    @Override
    public String toMdx() {
        StringBuilder mdx = new StringBuilder();
        if (this.formulas.size() > 0) {
            mdx.append("WITH ");
            Iterator<Formula> iter = this.formulas.iterator();
            while (iter.hasNext()) {
                mdx.append(' ');
                Formula form = iter.next();
                mdx.append(form.toMdx());
            }
            mdx.append(' ');
        }
        mdx.append("SELECT ");
        boolean isFollow = false;
        int i = 0;
        while (i < this.axes.length) {
            QueryAxis qa = this.axes[i];
            if (isFollow) {
                mdx.append(", ");
            }
            isFollow = true;
            mdx.append(qa.toMdx());
            ++i;
        }
        mdx.append(" FROM ");
        mdx.append(this.cubeName);
        if (this.slicer != null) {
            mdx.append(" WHERE ");
            mdx.append(this.slicer.toMdx());
        }
        return mdx.toString();
    }

    public Object clone() {
        MdxQuery cloned = new MdxQuery();
        if (this.formulas.size() > 0) {
            ArrayList<Formula> clonedFormulas = new ArrayList<Formula>();
            for (Formula form : this.formulas) {
                clonedFormulas.add((Formula)form.clone());
            }
            cloned.formulas = clonedFormulas;
        }
        if (this.axes.length > 0) {
            QueryAxis[] clonedAxes = new QueryAxis[this.axes.length];
            int i = 0;
            while (i < clonedAxes.length) {
                clonedAxes[i] = (QueryAxis)this.axes[i].clone();
                ++i;
            }
            cloned.setAxes(clonedAxes);
        }
        if (this.slicer != null) {
            cloned.slicer = (Exp)this.slicer.clone();
        }
        cloned.setCubeName("[" + this.getCubeName() + "]");
        return cloned;
    }

    public Exp getSlicer() {
        return this.slicer;
    }

    public void setSlicer(Exp exp) {
        this.slicer = exp;
    }

    public Formula addFormula(String[] names, Exp exp, MemberProperty[] memberProperties, CacheType cacheType) {
        Formula newFormula = new Formula(names, exp, memberProperties, cacheType);
        this.formulas.add(newFormula);
        return newFormula;
    }

    public void removeFormula(Formula formula) {
        this.formulas.remove(formula);
    }

    public Formula addFormula(String[] names, Exp exp) {
        Formula newFormula = new Formula(names, exp);
        this.formulas.add(newFormula);
        return newFormula;
    }

    public Formula addFormula(String[] names, Exp scope, Exp exp, MemberProperty[] memberProperties) {
        Formula formula = new Formula(names, scope, exp, memberProperties);
        this.formulas.add(formula);
        return formula;
    }

    public void removeFormula(String uniqueName) {
        Iterator<Formula> iter = this.formulas.iterator();
        while (iter.hasNext()) {
            Formula formula = iter.next();
            if (!uniqueName.equals(formula.getUniqeName())) continue;
            iter.remove();
        }
    }

    public void swapAxes() {
        if (this.axes.length == 2) {
            Exp e0 = this.axes[0].getExp();
            boolean nonEmpty0 = this.axes[0].isNonEmpty();
            DimensionProperty[] dimProps0 = this.axes[0].getResolvedProps();
            DimensionProperty[] dimProps1 = this.axes[1].getResolvedProps();
            Exp e1 = this.axes[1].getExp();
            boolean nonEmpty1 = this.axes[1].isNonEmpty();
            this.axes[1].setExp(e0);
            this.axes[1].setNonEmpty(nonEmpty0);
            this.axes[1].setResolvedProps(dimProps0);
            this.axes[0].setExp(e1);
            this.axes[0].setNonEmpty(nonEmpty1);
            this.axes[0].setResolvedProps(dimProps1);
        }
    }

    public Hierarchy[] getMdxHierarchiesOnAxis(int axis) {
        if (axis == -1 && this.slicer == null) {
            return null;
        }
        return this.collectHierarchies(axis == -1 ? this.slicer : this.axes[axis].getExp());
    }

    public Hierarchy[] collectHierarchies(Exp queryPart) {
        Type type = queryPart.getType();
        if (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        if (type instanceof TupleType) {
            Type[] types = ((TupleType)type).elementTypes;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            int i = 0;
            while (i < types.length) {
                Hierarchy hierarchy = types[i].getHierarchy();
                hierarchyList.add(hierarchy);
                ++i;
            }
            return hierarchyList.toArray(new Hierarchy[hierarchyList.size()]);
        }
        return new Hierarchy[]{type.getHierarchy()};
    }

    public Calc[] getAxisCalcs() {
        return this.axisCalcs;
    }

    public Calc getSlicerCalc() {
        return this.slicerCalc;
    }

    public void setAxisCalcs(Calc[] axisCalcs) {
        this.axisCalcs = axisCalcs;
    }

    public void setSlicerCalc(Calc slicerCalc) {
        this.slicerCalc = slicerCalc;
    }

    public Member[] getCalculatedMembers() throws OlapException {
        if (this.schemaReader == null) {
            this.getSchemaReader();
        }
        return this.schemaReader.getCalculatedMembers(this.schemaReader.getCube(this.cubeName));
    }

    public IListFactory getListFactory() {
        if (this.listFactory == null) {
            this.listFactory = DefaultListFactory.instance;
        }
        return this.listFactory;
    }

    public void release() {
        if (this.listFactory != null) {
            this.listFactory.release();
            this.listFactory = null;
        }
    }

    @Override
    public Exp parseExpression(String expression, boolean resolve) {
        Exp exp = ParserHelp.parseExpression(expression);
        if (resolve) {
            ExpResolver resolver = this.createExpResolver();
            return resolver.resolve(exp);
        }
        return exp;
    }

    @Override
    public LinkCellReader getLinkCellReader(String linkName) {
        LinkCellReader lcr;
        ConnectionImpl cn = (ConnectionImpl)this.connection;
        Connection linkConnection = cn.getLink(linkName);
        if (this.linkCellReaderMap == null) {
            this.linkCellReaderMap = new HashMap();
        }
        if ((lcr = this.linkCellReaderMap.get(linkName)) == null) {
            lcr = new LinkCellReader((ConnectionImpl)linkConnection);
            this.linkCellReaderMap.put(linkName, lcr);
        }
        return lcr;
    }

    private class CCFilter {
        int dimCount;
        RoaringLongBitSet[] bitSets;
        HashMap<Dimension, RoaringLongBitSet> bitSetMap = new HashMap();
        BBFilterIndexWithMeasure filterIndex;
        private boolean empty;
        private final CellCalculationInfo info;
        private final int index;
        private boolean hasMeasure;

        CCFilter(int index, CellCalculationInfo info, Evaluator evaluator) throws OlapException {
            Iterator iter;
            this.index = index;
            this.info = info;
            if (info.list == null) {
                info.list = info.listCalc.evaluateList(evaluator);
            }
            if (!(iter = info.list.iterator()).hasNext()) {
                this.empty = true;
                return;
            }
            Object o = iter.next();
            if (o instanceof Member) {
                this.init((Member)o, iter);
            } else {
                this.init((Member[])o, iter);
            }
        }

        private void init(Member[] ms, Iterator iter) throws OlapException {
            Member[] memberArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                Member m = memberArray[n2];
                if (m.isMeasure()) {
                    if (m.isCalculated()) {
                        throw new OlapException("Measure calculated member is not supported in cell calculation: " + m.getUniqueName());
                    }
                    this.hasMeasure = true;
                    break;
                }
                ++n2;
            }
            this.dimCount = ms.length;
            this.bitSets = new RoaringLongBitSet[this.dimCount];
            int[] indexes = new int[this.dimCount];
            int[] cards = new int[this.dimCount];
            int i = 0;
            while (i < this.dimCount) {
                DimensionImpl dim = (DimensionImpl)ms[i].getDimension();
                this.bitSets[i] = new RoaringLongBitSet();
                this.bitSetMap.put(dim, this.bitSets[i]);
                indexes[i] = MdxQuery.this.getDimensionIndexInCube(dim);
                cards[i] = dim.getMemberCount();
                ++i;
            }
            this.filterIndex = new BBFilterIndexWithMeasure(cards, indexes);
            while (true) {
                i = 0;
                while (i < this.dimCount) {
                    this.bitSets[i].set(ms[i].getGlobalOrder());
                    ms[i].getFilterBitSet().set(this.index);
                    ++i;
                }
                this.filterIndex.addNarrow(ms);
                if (!iter.hasNext()) break;
                ms = (Member[])iter.next();
            }
        }

        private void init(Member m, Iterator iter) throws OlapException {
            this.hasMeasure = m.isMeasure();
            if (this.hasMeasure && m.isCalculated()) {
                throw new OlapException("Measure calculated member is not supported in cell calculation: " + m.getUniqueName());
            }
            DimensionImpl dim = (DimensionImpl)m.getDimension();
            this.dimCount = 1;
            this.bitSets = new RoaringLongBitSet[1];
            this.bitSets[0] = new RoaringLongBitSet();
            this.bitSetMap.put(dim, this.bitSets[0]);
            int[] indexes = new int[]{MdxQuery.this.getDimensionIndexInCube(m.getDimension())};
            int[] cards = new int[]{dim.getMemberCount()};
            this.filterIndex = new BBFilterIndexWithMeasure(cards, indexes);
            while (true) {
                this.bitSets[0].set(m.getGlobalOrder());
                m.getFilterBitSet().set(this.index);
                this.filterIndex.addNarrow(m);
                if (!iter.hasNext()) break;
                m = (Member)iter.next();
            }
        }

        boolean hasMemberContext(Member[] members, Member measure) {
            if (this.empty) {
                return false;
            }
            if (this.hasMeasure) {
                return this.filterIndex.get(members, measure);
            }
            return this.filterIndex.get(members);
        }
    }

    private class CCFilters {
        CCFilter[] filters;
        HashMap<Dimension, RoaringLongBitSet> dimensionBitSetMap = new HashMap();
        RoaringLongBitSet[] dimensionBitSets = null;
        RoaringLongBitSet measureBitSet = null;
        private int[] hasFilterDimensionIndex = null;
        RoaringIntBitSet tempBitSet = new RoaringIntBitSet();

        public CCFilters() throws OlapException {
            if (MdxQuery.this.cellCalculations == null || MdxQuery.this.cellCalculations.isEmpty()) {
                return;
            }
            this.filters = new CCFilter[MdxQuery.this.cellCalculations.size()];
            Evaluator evaluator = null;
            int i = 0;
            while (i < this.filters.length) {
                CCFilter filter;
                evaluator = MdxQuery.this.createEvaluator();
                this.filters[i] = filter = new CCFilter(i, (CellCalculationInfo)MdxQuery.this.cellCalculations.get(i), evaluator);
                for (Map.Entry<Dimension, RoaringLongBitSet> entry : filter.bitSetMap.entrySet()) {
                    Dimension dim = entry.getKey();
                    if (dim.isMeasureDimension()) {
                        if (this.measureBitSet != null) {
                            this.measureBitSet.or(entry.getValue());
                            continue;
                        }
                        this.measureBitSet = entry.getValue();
                        continue;
                    }
                    RoaringLongBitSet bs = this.dimensionBitSetMap.get(dim);
                    if (bs != null) {
                        bs.or(entry.getValue());
                        continue;
                    }
                    this.dimensionBitSetMap.put(dim, entry.getValue());
                }
                ++i;
            }
            Member[] ms = evaluator.getCurrentMembers();
            this.dimensionBitSets = new RoaringLongBitSet[ms.length];
            this.hasFilterDimensionIndex = new int[this.dimensionBitSetMap.size()];
            int cur = 0;
            int i2 = 0;
            while (i2 < ms.length) {
                this.dimensionBitSets[i2] = this.dimensionBitSetMap.get(ms[i2].getDimension());
                if (this.dimensionBitSets[i2] != null) {
                    this.hasFilterDimensionIndex[cur++] = i2;
                }
                ++i2;
            }
        }

        private IntIterator getFilterIntIterator(Member[] members, Member measure) {
            this.tempBitSet.clear();
            int i = 0;
            while (i < this.hasFilterDimensionIndex.length) {
                this.tempBitSet.or(members[this.hasFilterDimensionIndex[i]].getFilterBitSet());
                ++i;
            }
            if (this.measureBitSet != null) {
                this.tempBitSet.or(measure.getFilterBitSet());
            }
            return this.tempBitSet.reverseIterator();
        }

        Calc getCellCalculationInfo(Evaluator evaluator) throws OlapException {
            if (evaluator.getCurrentMeasure().isCalculated()) {
                return null;
            }
            Member[] members = evaluator.getCurrentMembers();
            IntIterator iter = this.getFilterIntIterator(members, evaluator.getCurrentMeasure());
            while (iter.hasNext()) {
                int i = iter.next();
                if (!this.filters[i].hasMemberContext(members, evaluator.getCurrentMeasure())) continue;
                CellCalculationInfo info = this.filters[i].info;
                if (info.conditionCalc != null) {
                    if (!info.conditionCalc.evaluateBoolean(evaluator)) continue;
                    return info.calc;
                }
                return info.calc;
            }
            return null;
        }
    }

    private static class CellCalculationInfo {
        boolean forAll;
        ListCalc listCalc;
        Calc calc;
        BooleanCalc conditionCalc;
        IList list;

        public CellCalculationInfo(boolean forAll, ListCalc listCalc, Calc calc, BooleanCalc conditionCalc) {
            this.forAll = forAll;
            this.listCalc = listCalc;
            this.calc = calc;
            this.conditionCalc = conditionCalc;
        }
    }

    private class QuerySchemaReader
    extends DelegatingSchemaReader {
        public QuerySchemaReader(SchemaReader schemaReader) {
            super(schemaReader);
        }

        @Override
        public Member getMemberByUniqueName(Cube cube, String uniqueName) throws OlapException {
            Member member = this.getCalculatedMember(cube, uniqueName);
            if (member == null) {
                member = this.schemaReader.getMemberByUniqueName(cube, uniqueName);
            }
            return member;
        }

        @Override
        public Member getCalculatedMember(Cube cube, String uniqueName) {
            Member member = MdxQuery.this.lookupMemberFromDefined(uniqueName);
            if (member == null) {
                member = this.schemaReader.getCalculatedMember(cube, uniqueName);
            }
            return member;
        }

        @Override
        public Member[] getCalculatedMembers(Cube cube, Hierarchy hierarchy) {
            ArrayList<Member> result = new ArrayList<Member>();
            HashSet<String> set = new HashSet<String>();
            for (Formula formula : MdxQuery.this.formulas) {
                Member member;
                if (!formula.isMember() || !(member = formula.getMember()).getHierarchy().equals(hierarchy)) continue;
                set.add(member.getUniqueName());
                result.add(member);
            }
            Member[] cMemberInSchema = this.schemaReader.getCalculatedMembers(cube, hierarchy);
            if (cMemberInSchema != null) {
                int i = 0;
                while (i < cMemberInSchema.length) {
                    if (!set.contains(cMemberInSchema[i].getUniqueName())) {
                        result.add(cMemberInSchema[i]);
                    }
                    ++i;
                }
            }
            return result.toArray(new Member[0]);
        }

        @Override
        public Member[] getCalculatedMembers(Cube cube) throws OlapException {
            ArrayList<Member> result = new ArrayList<Member>(2);
            HashSet<String> set = new HashSet<String>(2);
            for (Formula formula : MdxQuery.this.formulas) {
                if (!formula.isMember()) continue;
                Member member = formula.getMember();
                set.add(member.getUniqueName());
                result.add(member);
            }
            Member[] cMemberInSchema = this.schemaReader.getCalculatedMembers(cube);
            if (cMemberInSchema != null) {
                int i = 0;
                while (i < cMemberInSchema.length) {
                    if (!set.contains(cMemberInSchema[i].getUniqueName())) {
                        result.add(cMemberInSchema[i]);
                    }
                    ++i;
                }
            }
            return result.toArray(new Member[0]);
        }

        public Set getSet(String name) {
            int i = 0;
            while (i < MdxQuery.this.formulas.size()) {
                Formula formula = MdxQuery.this.formulas.get(i);
                if (formula.isSet() && formula.getFirstName().equalsIgnoreCase(name)) {
                    return formula.getSet();
                }
                ++i;
            }
            return null;
        }

        @Override
        public OlapElement getElementChild(OlapElement parent, String s) throws OlapException {
            OlapElement mdxElement = this.schemaReader.getElementChild(parent, s);
            if (mdxElement != null) {
                return mdxElement;
            }
            int i = 0;
            while (i < MdxQuery.this.formulas.size()) {
                Formula formula = MdxQuery.this.formulas.get(i);
                if (formula.isSet() && formula.getFirstName().equalsIgnoreCase(s)) {
                    return formula.getSet();
                }
                ++i;
            }
            return mdxElement;
        }

        @Override
        public OlapElement lookupCompound(OlapElement parent, String[] names, int category) throws OlapException {
            switch (category) {
                case 0: 
                case 6: {
                    Set set;
                    if (parent != this.getCube(MdxQuery.this.cubeName)) break;
                    String uniqueName = UniqueNameUtil.createUniqueName(names);
                    Member calculatedMember = this.getCalculatedMember(this.getCube(MdxQuery.this.cubeName), uniqueName);
                    if (calculatedMember != null) {
                        return calculatedMember;
                    }
                    if (names.length != 1 || (set = this.getSet(names[0])) == null) break;
                    return set;
                }
            }
            OlapElement olapElement = super.lookupCompound(parent, names, category);
            return olapElement;
        }
    }
}

