/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx;

import java.io.StringReader;
import java_cup.runtime.Symbol;
import kd.bos.algo.olap.Connection;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.impl.Stats;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.Lexer;
import kd.bos.algo.olap.mdx.MdxParseException;
import kd.bos.algo.olap.mdx.MdxQuery;
import kd.bos.algo.olap.mdx.parser;
import org.apache.log4j.Logger;

public class ParserHelp {
    private static Logger logger = Logger.getLogger(ParserHelp.class);

    public static Exp parseExpression(String expression) throws OlapException {
        try {
            StringReader reader = new StringReader(expression);
            Lexer lexer = new Lexer(reader);
            parser p = new parser(lexer);
            Symbol parse_tree = null;
            parse_tree = p.parse();
            Exp exp = (Exp)parse_tree.value;
            return exp;
        }
        catch (OlapException e) {
            logger.info((Object)("\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519:" + expression));
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)("\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519:" + expression));
            throw new MdxParseException(e.getMessage(), e);
        }
    }

    public static MdxQuery parseQuery(Connection connection, String mdx, Stats stats) throws OlapException {
        long t1 = System.currentTimeMillis();
        try {
            Stats.StatItem item = stats.createStatItem("parse mdx");
            StringReader reader = new StringReader(mdx);
            Lexer lexer = new Lexer(reader);
            parser p = new parser(lexer);
            Symbol parse_tree = null;
            parse_tree = p.parse();
            MdxQuery query = (MdxQuery)parse_tree.value;
            item.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parseQuery mdx 1 cost " + (System.currentTimeMillis() - t1) + "\n"));
            }
            item = stats.createStatItem("resolve mdx");
            query.afterParse(connection);
            item.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parseQuery mdx afterParser cost " + (System.currentTimeMillis() - t1) + "ms.mdx is\n" + mdx));
            }
            return query;
        }
        catch (OlapException e) {
            logger.info((Object)("mdx\u89e3\u6790\u51fa\u9519:" + mdx));
            throw e;
        }
        catch (Exception e) {
            logger.info((Object)("mdx\u89e3\u6790\u51fa\u9519:" + mdx));
            throw new MdxParseException(e.getMessage(), e);
        }
    }

    public static void report_error(String message, Object info) {
        logger.debug((Object)("MDX\u8bed\u6cd5\u9519\u8bef," + message));
        if (info instanceof Symbol && ((Symbol)info).left != -1) {
            logger.debug((Object)("\n\u5728\u7b2c" + ((Symbol)info).left + "\u4e2a\u5b57\u7b26"));
        }
    }

    public static void report_fatal_error(String message, Object info) throws Exception {
        String err = "MDX\u8bed\u6cd5\u9519\u8bef," + message;
        err = info instanceof Symbol ? (((Symbol)info).left != -1 ? String.valueOf(err) + "\n\u5728\u7b2c" + ((Symbol)info).left + "\u4e2a\u5b57\u7b26" : (((Symbol)info).value == null ? String.valueOf(err) + "\n\u8bed\u53e5\u672a\u6b63\u5e38\u7ed3\u675f,\u53ef\u80fd\u662f\u7f3a\u5c11)\u6216]\u7b49\u5339\u914d\u7b26\u53f7." : String.valueOf(err) + "\n\u65e0\u6548\u7b26\u53f7\"" + ((Symbol)info).value + "\"")) : String.valueOf(err) + "\n" + info.toString();
        logger.debug((Object)err);
        throw new MdxParseException(err);
    }
}

