/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl;

import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.Scope;
import kd.bos.algo.olap.mdx.type.Type;

public abstract class AbstractCalc
implements Calc {
    protected Type type;
    protected Exp exp;

    protected AbstractCalc(Exp exp) {
        this.exp = exp;
        if (exp != null) {
            this.type = exp.getType();
        }
    }

    @Override
    public Type getType() {
        return this.type;
    }

    protected String getName() {
        String name;
        if (this.exp != null && this.exp instanceof FunCall) {
            FunCall funCall = (FunCall)this.exp;
            name = funCall.getFunDef().getName();
        } else {
            int dollar;
            name = this.getClass().getName();
            int dot = name.lastIndexOf(46);
            int dotDollar = Math.max(dot, dollar = name.lastIndexOf(36));
            if (dotDollar >= 0) {
                name = name.substring(dotDollar + 1);
            }
        }
        return name;
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OlapException {
        Calc[] calcs = this.getCalcs();
        if (calcs != null) {
            int i = 0;
            while (i < calcs.length) {
                if (calcs[i] != null) {
                    calcs[i] = calcs[i].optimize(scope, evaluator);
                }
                ++i;
            }
        }
        return this;
    }
}

