/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.IntegerCalc;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractTupleCalc;
import kd.bos.algo.olap.mdx.type.MemberType;
import kd.bos.algo.olap.mdx.type.SetType;
import kd.bos.algo.olap.mdx.type.TupleType;
import kd.bos.algo.olap.mdx.type.Type;

public class ItemTupleCalc
extends AbstractTupleCalc {
    ListCalc listCalc;
    IntegerCalc intCalc;

    public ItemTupleCalc(Exp exp, ListCalc listCalc, IntegerCalc intCalc) {
        super(exp, new Calc[]{listCalc, intCalc});
        this.listCalc = listCalc;
        this.intCalc = intCalc;
    }

    @Override
    public Member[] evaluateTuple(Evaluator evaluator) throws OlapException {
        int listSize;
        IList list = this.listCalc.evaluateList(evaluator);
        int index = this.intCalc.evaluateInteger(evaluator);
        if (index >= (listSize = list.size()) || index < 0) {
            return this.makeNullTuple();
        }
        return (Member[])list.get(index);
    }

    public Member[] makeNullTuple() {
        Type elementType = ((SetType)this.listCalc.getType()).getElementType();
        TupleType tupleType = (TupleType)elementType;
        Member[] members = new Member[tupleType.elementTypes.length];
        int i = 0;
        while (i < tupleType.elementTypes.length) {
            MemberType type = (MemberType)tupleType.elementTypes[i];
            members[i] = this.makeNullMember(type);
            ++i;
        }
        return members;
    }

    Member makeNullMember(MemberType memberType) {
        Hierarchy hierarchy = memberType.getHierarchy();
        if (hierarchy == null) {
            return null;
        }
        return hierarchy.getNullMember();
    }
}

