/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.FunctionException;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.HierarchyCalc;
import kd.bos.algo.olap.mdx.calc.IntegerCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractLevelCalc;

public class LevelsCalc
extends AbstractLevelCalc {
    HierarchyCalc hierarchyCalc;
    IntegerCalc ordinalCalc;

    public LevelsCalc(Exp exp, HierarchyCalc hierarchyCalc, IntegerCalc ordinalCalc) {
        super(exp, new Calc[]{hierarchyCalc, ordinalCalc});
        this.hierarchyCalc = hierarchyCalc;
        this.ordinalCalc = ordinalCalc;
    }

    @Override
    public Level evaluateLevel(Evaluator evaluator) throws OlapException {
        Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
        int n = this.ordinalCalc.evaluateInteger(evaluator);
        if (hierarchy.getDimension().isParentChildrenDimension()) {
            Level level = hierarchy.getLevels()[0];
            while (level != null && n > level.getDepth()) {
                level = level.getChildLevel();
            }
            if (level == null) {
                throw new FunctionException("Levels Index '" + n + "' out of bounds");
            }
            return level;
        }
        Level[] levels = hierarchy.getLevels();
        if (n >= levels.length || n < 0) {
            throw new FunctionException("Levels Index '" + n + "' out of bounds");
        }
        return levels[n];
    }
}

