/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl.func;

import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.collection.ListFactoryFactory;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.Scope;
import kd.bos.algo.olap.mdx.calc.impl.AbstractListCalc;

public class UnionCalc
extends AbstractListCalc {
    private ListCalc listCalc1;
    private ListCalc listCalc2;

    public UnionCalc(Exp exp, ListCalc listCalc1, ListCalc listCalc2, boolean all) {
        super(exp, new Calc[]{listCalc1, listCalc2});
        this.listCalc1 = listCalc1;
        this.listCalc2 = listCalc2;
    }

    @Override
    public IList evaluateList(Evaluator evaluator) throws OlapException {
        IList left = this.listCalc1.evaluateList(evaluator);
        IList right = this.listCalc2.evaluateList(evaluator);
        return ListFactoryFactory.getListFactory().createUnionList(left, right);
    }

    @Override
    public Calc optimize(Scope scope, Evaluator evaluator) throws OlapException {
        Calc[] calcs = this.getCalcs();
        int i = 0;
        while (i < calcs.length) {
            calcs[i] = calcs[i].optimize(scope, evaluator);
            ++i;
        }
        return this;
    }
}

