/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.elementexp;

import java.util.Iterator;
import java.util.List;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.SchemaLookup;
import kd.bos.algo.olap.mdx.elementexp.DimensionExpr;
import kd.bos.algo.olap.mdx.elementexp.HierarchyExpr;
import kd.bos.algo.olap.mdx.elementexp.LevelExpr;
import kd.bos.algo.olap.mdx.elementexp.MemberExpr;

public class ExprUtil {
    public static Exp toExp(OlapElement ele) {
        if (ele == null) {
            return null;
        }
        return SchemaLookup.createExpr(ele);
    }

    public static MemberExpr[] toExp(Member[] members) {
        MemberExpr[] exprs = new MemberExpr[members.length];
        int i = 0;
        while (i < exprs.length) {
            exprs[i] = new MemberExpr(members[i]);
            ++i;
        }
        return exprs;
    }

    public static MemberExpr[] toExp(List members) {
        MemberExpr[] exprs = new MemberExpr[members.size()];
        int i = 0;
        while (i < exprs.length) {
            exprs[i] = new MemberExpr((Member)members.get(i));
            ++i;
        }
        return exprs;
    }

    public static MemberExpr[] toExp(IList members) {
        MemberExpr[] exprs = new MemberExpr[members.size()];
        int i = 0;
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            exprs[i++] = new MemberExpr((Member)iter.next());
        }
        return exprs;
    }

    public static Member toMember(Exp exp) {
        if (exp == null) {
            return null;
        }
        return ((MemberExpr)exp).getMember();
    }

    public static Level toLevel(Exp exp) {
        if (exp == null) {
            return null;
        }
        return ((LevelExpr)exp).getLevel();
    }

    public static Hierarchy toHierarchy(Exp exp) {
        if (exp == null) {
            return null;
        }
        return ((HierarchyExpr)exp).getHierarchy();
    }

    public static Dimension toDimension(Exp exp) {
        if (exp == null) {
            return null;
        }
        return ((DimensionExpr)exp).getDimension();
    }
}

