/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.func;

import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.FunDefBase;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.MemberCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractLevelCalc;
import kd.bos.algo.olap.mdx.type.LevelType;
import kd.bos.algo.olap.mdx.type.Type;

public class MemberLevelFunDef
extends FunDefBase {
    static final MemberLevelFunDef instance = new MemberLevelFunDef();

    private MemberLevelFunDef() {
        super("Level", "<Member>.Level", "Returns a member's level.", "plm");
    }

    @Override
    public Type getResultType(ExpResolver resolver, Exp[] args) {
        Type argType = args[0].getType();
        return LevelType.forType(argType);
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new CalcImpl((Exp)call, memberCalc);
    }

    public static class CalcImpl
    extends AbstractLevelCalc {
        private final MemberCalc memberCalc;

        public CalcImpl(Exp exp, MemberCalc memberCalc) {
            super(exp, new Calc[]{memberCalc});
            this.memberCalc = memberCalc;
        }

        @Override
        public Level evaluateLevel(Evaluator evaluator) throws OlapException {
            Member member = this.memberCalc.evaluateMember(evaluator);
            return member.getLevel();
        }
    }
}

