/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.func;

import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.Property;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.FunDef;
import kd.bos.algo.olap.mdx.FunDefBase;
import kd.bos.algo.olap.mdx.FuncResolverBase;
import kd.bos.algo.olap.mdx.Literal;
import kd.bos.algo.olap.mdx.Syntax;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.MemberCalc;
import kd.bos.algo.olap.mdx.calc.StringCalc;
import kd.bos.algo.olap.mdx.calc.impl.GenericCalc;
import kd.bos.algo.olap.util.IntHolder;

class PropertiesFunDef
extends FunDefBase {
    public PropertiesFunDef(String name, String description, Syntax syntax, int returnType, int[] parameterTypes) {
        super(name, description, syntax, returnType, parameterTypes);
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        final StringCalc stringCalc = compiler.compileString(call.getArg(1));
        return new GenericCalc(call){

            @Override
            public Calc[] getCalcs() {
                return new Calc[]{memberCalc, stringCalc};
            }

            @Override
            public Object evaluate(Evaluator evaluator) throws OlapException {
                String s;
                Member member = memberCalc.evaluateMember(evaluator);
                Object o = member.getProperty(s = stringCalc.evaluateString(evaluator));
                if (o == null) {
                    return null;
                }
                if (o instanceof Number || o instanceof Boolean || o instanceof String) {
                    return o;
                }
                return o.toString();
            }
        };
    }

    private static Property lookupProperty(Level level, String propertyName) {
        do {
            Property[] properties;
            if ((properties = level.getMemberProperties()) == null) {
                return null;
            }
            int i = 0;
            while (i < properties.length) {
                Property property = properties[i];
                if (property.getName().equals(propertyName)) {
                    return property;
                }
                ++i;
            }
        } while ((level = level.getParentLevel()) != null);
        return null;
    }

    static class Resolver
    extends FuncResolverBase {
        Resolver() {
            super("Properties", "<Member>.Properties(<String Expression>)", "Returns the value of a member property.", Syntax.Method);
        }

        @Override
        public FunDef resolve(Exp[] args, IntHolder conversionCount) {
            int[] argTypes = new int[]{6, 9};
            if (args.length != 2 || args[0].getCategory() != 6 || args[1].getCategory() != 9) {
                return null;
            }
            int returnType = 9;
            if (args[1] instanceof Literal) {
                String dataType;
                String propertyName = ((Literal)args[1]).stringValue();
                Hierarchy hierarchy = args[0].getType().getHierarchy();
                Level[] levels = hierarchy.getLevels();
                Property property = PropertiesFunDef.lookupProperty(levels[levels.length - 1], propertyName);
                returnType = property == null ? 13 : ((dataType = (String)property.getProperty("dataType")) == null ? 9 : (dataType.equals("BOOLEAN") ? 5 : (dataType.equalsIgnoreCase("NUMERIC") ? 7 : (dataType.equalsIgnoreCase("STRING") ? 9 : 9))));
            } else {
                returnType = 13;
            }
            return new PropertiesFunDef(this.getName(), this.getDescription(), this.getSyntax(), returnType, argTypes);
        }

        @Override
        public boolean requireScalarExpression(int k) {
            return true;
        }
    }
}

