/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.func;

import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.FunCall;
import kd.bos.algo.olap.mdx.FunDef;
import kd.bos.algo.olap.mdx.FunDefBase;
import kd.bos.algo.olap.mdx.FuncResolver;
import kd.bos.algo.olap.mdx.FunctionException;
import kd.bos.algo.olap.mdx.MultiFuncResolver;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.MemberCalc;
import kd.bos.algo.olap.mdx.calc.impl.func.XtdCalc;
import kd.bos.algo.olap.mdx.func.FuncUtil2;
import kd.bos.algo.olap.mdx.type.MemberType;
import kd.bos.algo.olap.mdx.type.SetType;
import kd.bos.algo.olap.mdx.type.Type;

class XtdFunDef
extends FunDefBase {
    private final byte levelType;

    public XtdFunDef(FuncResolver resolver, int returnType, int[] parameterTypes, byte levelType) {
        super(resolver, returnType, parameterTypes);
        this.levelType = levelType;
    }

    @Override
    public Type getResultType(ExpResolver resolver, Exp[] args) throws OlapException {
        if (args.length == 0) {
            Hierarchy hierarchy = resolver.getSchemaReader().getCube().getTimeDimension().getHierarchy();
            return new SetType(new MemberType(hierarchy, null, null));
        }
        Type type = args[0].getType();
        if (!type.getHierarchy().getDimension().isTimeDimension()) {
            throw new FunctionException("Funciton '" + this.getName() + "' need Time Dimension.");
        }
        return super.getResultType(resolver, args);
    }

    private Level getLevel(Cube cube) {
        switch (this.levelType) {
            case 2: {
                return FuncUtil2.getTimeLevel(cube, (byte)2);
            }
            case 3: {
                return FuncUtil2.getTimeLevel(cube, (byte)3);
            }
            case 4: {
                return FuncUtil2.getTimeLevel(cube, (byte)4);
            }
            case 5: {
                return FuncUtil2.getTimeLevel(cube, (byte)5);
            }
            case 6: {
                return FuncUtil2.getTimeLevel(cube, (byte)5);
            }
        }
        return null;
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OlapException {
        Level level = this.getLevel(compiler.getResolver().getSchemaReader().getCube());
        MemberCalc memberCalc = null;
        if (call.getArgCount() > 0) {
            memberCalc = compiler.compileMember(call.getArg(0));
        }
        return new XtdCalc(call, level, memberCalc);
    }

    public static class Resolver
    extends MultiFuncResolver {
        private final byte levelType;

        public Resolver(String name, String signature, String description, String[] signatures, byte levelType) {
            super(name, signature, description, signatures);
            this.levelType = levelType;
        }

        @Override
        protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
            return new XtdFunDef(this, returnType, parameterTypes, this.levelType);
        }
    }
}

