/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.util.Util;

public class EnumeratedValues
implements Cloneable {
    private HashMap valuesByName = new HashMap();
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;
    private Value[] ordinalToValueMap;
    private static final String[] emptyStringArray = new String[0];

    public EnumeratedValues() {
    }

    public EnumeratedValues(Value[] values) {
        int i = 0;
        while (i < values.length) {
            this.register(values[i]);
            ++i;
        }
        this.makeImmutable();
    }

    public EnumeratedValues(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.register(new BasicValue(names[i], i, names[i]));
            ++i;
        }
        this.makeImmutable();
    }

    public EnumeratedValues(String[] names, int[] codes) {
        int i = 0;
        while (i < names.length) {
            this.register(new BasicValue(names[i], codes[i], names[i]));
            ++i;
        }
        this.makeImmutable();
    }

    public EnumeratedValues(String[] names, int[] codes, String[] descriptions) {
        int i = 0;
        while (i < names.length) {
            this.register(new BasicValue(names[i], codes[i], descriptions[i]));
            ++i;
        }
        this.makeImmutable();
    }

    protected Object clone() {
        EnumeratedValues clone = null;
        try {
            clone = (EnumeratedValues)super.clone();
            clone.valuesByName = (HashMap)this.valuesByName.clone();
            clone.ordinalToValueMap = null;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            return new OlapException(ex);
        }
    }

    public EnumeratedValues getMutableClone() {
        return (EnumeratedValues)this.clone();
    }

    public void register(Value value) {
        Util.assertPrecondition(value != null, "value != null");
        Util.assertPrecondition(!this.isImmutable(), "isImmutable()");
        String name = value.getName();
        Util.assertPrecondition(name != null, "value.getName() != null");
        Value old = this.valuesByName.put(name, value);
        if (old != null) {
            throw Util.newInternal("Enumeration already contained a value '" + old.getName() + "'");
        }
        int ordinal = value.getOrdinal();
        this.min = Math.min(this.min, ordinal);
        this.max = Math.max(this.max, ordinal);
    }

    public void makeImmutable() {
        this.ordinalToValueMap = new Value[1 + this.max - this.min];
        for (Value value : this.valuesByName.values()) {
            int index = value.getOrdinal() - this.min;
            if (this.ordinalToValueMap[index] != null) {
                throw Util.newInternal("Enumeration has more than one value with ordinal " + value.getOrdinal());
            }
            this.ordinalToValueMap[index] = value;
        }
    }

    public final boolean isImmutable() {
        return this.ordinalToValueMap != null;
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public final boolean isValid(int ordinal) {
        if (ordinal < this.min || ordinal > this.max) {
            return false;
        }
        return this.getName(ordinal) != null;
    }

    public final Value getValue(int ordinal) {
        Util.assertPrecondition(this.isImmutable());
        return this.ordinalToValueMap[ordinal - this.min];
    }

    public final String getName(int ordinal) {
        Util.assertPrecondition(this.isImmutable());
        Value value = this.ordinalToValueMap[ordinal - this.min];
        return value == null ? null : value.getName();
    }

    public final String getDescription(int ordinal) {
        Util.assertPrecondition(this.isImmutable());
        Value value = this.ordinalToValueMap[ordinal - this.min];
        return value == null ? null : value.getDescription();
    }

    public final int getOrdinal(String name) {
        return this.getValue(name).getOrdinal();
    }

    public Value getValue(String name) {
        Value value = (Value)this.valuesByName.get(name);
        return value;
    }

    public String[] getNames() {
        return this.valuesByName.keySet().toArray(emptyStringArray);
    }

    public List getValuesSortedByName() {
        Object[] names = this.getNames();
        Arrays.sort(names);
        ArrayList<Value> list = new ArrayList<Value>(names.length);
        int i = 0;
        while (i < names.length) {
            Object name = names[i];
            list.add(this.getValue((String)name));
            ++i;
        }
        return list;
    }

    public RuntimeException badValue(int ordinal) {
        return Util.newInternal("bad value " + ordinal + "(" + this.getName(ordinal) + ") for enumeration '" + this.getClass().getName() + "'");
    }

    public RuntimeException unexpected(Value value) {
        return Util.newInternal("Was not expecting value '" + value + "' for enumeration '" + this.getClass().getName() + "' in this context");
    }

    public static class BasicValue
    implements Value,
    Serializable {
        public final String name_;
        public final int ordinal_;
        public final String description_;

        public BasicValue(String name, int ordinal, String description) {
            Util.assertPrecondition(name != null, "name != null");
            this.name_ = name;
            this.ordinal_ = ordinal;
            this.description_ = description;
        }

        @Override
        public String getName() {
            return this.name_;
        }

        @Override
        public int getOrdinal() {
            return this.ordinal_;
        }

        @Override
        public String getDescription() {
            return this.description_;
        }

        public String toString() {
            return this.name_;
        }

        public RuntimeException unexpected() {
            return Util.newInternal("Value " + this.name_ + " of class " + this.getClass() + " unexpected here");
        }
    }

    public static interface Value {
        public String getName();

        public int getOrdinal();

        public String getDescription();
    }
}

