/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.util;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FileUtil {
    private static Logger log = Logger.getLogger(FileUtil.class);
    private static String dir;

    static {
        String userdir = System.getProperty("java.io.tmpdir");
        dir = String.valueOf(userdir) + File.separator + "kdtemp";
        File f = new File(dir);
        if (!f.exists()) {
            if (!f.mkdir()) {
                log.error((Object)"Can't make temp directory. ");
                dir = userdir;
            }
        } else {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        }
    }

    public static String getTempFileName() {
        long time = System.currentTimeMillis();
        String tempFileName = "olap" + time;
        return tempFileName;
    }

    public static File createSystemTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.createKingdeeTempFile(prefix, suffix);
    }

    public static File createKingdeeTempFile(String prefix, String suffix) throws IOException {
        File file = null;
        int i = 0;
        IOException ioe = null;
        do {
            try {
                file = File.createTempFile(prefix, suffix, new File(dir));
            }
            catch (IOException e) {
                ioe = e;
                log.warn((Object)("Fail when create Kingdee Temp File:" + e.getMessage()));
                log.warn((Object)("\nThis is the " + (i + 1) + " time,try again."));
            }
        } while (file == null && i++ < 5);
        if (file == null && ioe != null) {
            throw ioe;
        }
        if (file != null) {
            file.deleteOnExit();
            return file;
        }
        throw new IOException("Fail when create Kingdee Temp File");
    }
}

