/*
 * Decompiled with CFR 0.152.
 */
package kobetool.dshowwrapper;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import kobetool.dshowwrapper.CaptureDevice;
import kobetool.dshowwrapper.GUID;
import kobetool.dshowwrapper.VideoFormat;

public class PCICamera
extends JPanel {
    private JCheckBox hFlip = new JCheckBox("Flip Horizontal");
    private String PCI_CAMERA1 = "subsys_bacbbf01";
    private String PCI_CAMERA2 = "subsys_bacbbf02";
    private String FRONT = "font";
    private String BACK = "back";
    private BufferedImage img1 = null;
    private BufferedImage img2 = null;
    private ByteBuffer buf1 = null;
    private ByteBuffer buf2 = null;
    private int video_width = 320;
    private int video_height = 240;
    private GUID guid = GUID.RGB24;
    private VideoFormat vFormat = new VideoFormat(this.video_width, this.video_height, this.guid);
    JTabbedPane tabPane = new JTabbedPane();
    Panel panel1 = new Panel(new BorderLayout());
    Panel panel2 = new Panel(new BorderLayout());
    Panel paneEmpty = new Panel();
    Action play = new AbstractAction("Play"){

        public void actionPerformed(ActionEvent e) {
            CaptureDevice device1;
            CaptureDevice device0 = (CaptureDevice)PCICamera.this.panel1.getComponent(0);
            if (device0 == null) {
                return;
            }
            if (!device0.start(PCICamera.this.vFormat, PCICamera.this.hFlip.isSelected())) {
                JOptionPane.showMessageDialog(PCICamera.this, "The Device does not support the format.");
            }
            if ((device1 = (CaptureDevice)PCICamera.this.panel2.getComponent(0)) == null) {
                return;
            }
            if (!device1.start(PCICamera.this.vFormat, PCICamera.this.hFlip.isSelected())) {
                JOptionPane.showMessageDialog(PCICamera.this, "The Device does not support the format.");
            }
        }
    };
    Action stop = new AbstractAction("Stop"){

        public void actionPerformed(ActionEvent e) {
            CaptureDevice device0 = (CaptureDevice)PCICamera.this.panel1.getComponent(0);
            if (device0 == null) {
                return;
            }
            device0.stop();
            device0.repaint();
            CaptureDevice device1 = (CaptureDevice)PCICamera.this.panel2.getComponent(0);
            if (device1 == null) {
                return;
            }
            device1.stop();
            device1.repaint();
        }
    };
    Action grab = new AbstractAction("grab"){

        public void actionPerformed(ActionEvent e) {
            PCICamera.this.captureImage(PCICamera.this.panel1, PCICamera.this.buf1, PCICamera.this.img1, PCICamera.this.FRONT);
            PCICamera.this.captureImage(PCICamera.this.panel2, PCICamera.this.buf2, PCICamera.this.img2, PCICamera.this.BACK);
        }
    };

    PCICamera() {
        JToolBar tb = new JToolBar();
        this.add((Component)tb, "East");
        tb.add(this.play);
        tb.add(this.stop);
        tb.add(this.grab);
        this.setLayout(new GridLayout(1, 2));
        this.paneEmpty.setPreferredSize(new Dimension(10, 10));
        this.panel1.setSize(320, 240);
        this.panel2.setPreferredSize(new Dimension(320, 240));
        this.panel2.setSize(320, 240);
        this.panel2.setPreferredSize(new Dimension(320, 240));
        this.add((Component)this.panel2, "North");
        this.add((Component)this.panel1, "South");
        this.add((Component)this.paneEmpty, "Center");
        Iterator iterator = CaptureDevice.enumDevices().iterator();
        while (iterator.hasNext()) {
            CaptureDevice cd = (CaptureDevice)iterator.next();
            String[] str = cd.getDevicePath().split("&");
            if (str[2].equals(this.PCI_CAMERA1)) {
                this.panel1.add((Component)cd, "Center");
            }
            if (!str[2].equals(this.PCI_CAMERA2)) continue;
            this.panel2.add((Component)cd, "Center");
        }
        this.setSize(800, 250);
        this.setVisible(true);
    }

    protected BufferedImage captureImage(Panel panel, ByteBuffer buf, BufferedImage img, String location) {
        CaptureDevice device = (CaptureDevice)panel.getComponent(0);
        if (device == null) {
            return null;
        }
        VideoFormat fmt = device.getFormat();
        if (fmt == null) {
            return null;
        }
        if (!fmt.getSubType().equals(GUID.RGB24)) {
            JOptionPane.showMessageDialog(this, "Can only grab rgb24 image.");
            return null;
        }
        buf = device.grab(null);
        img = new BufferedImage(fmt.getWidth(), fmt.getHeight(), 5);
        byte[] data = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        buf.rewind();
        int i = img.getWidth() * (img.getHeight() - 1) * 3;
        while (i >= 0) {
            buf.get(data, i, img.getWidth() * 3);
            i -= img.getWidth() * 3;
        }
        File file = new File(String.valueOf(location) + Calendar.getInstance().getTimeInMillis());
        String fn = file.getName().toUpperCase();
        if (!fn.endsWith(".JPG") && !fn.endsWith(".JPEG")) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".jpg");
        }
        try {
            try {
                ImageIO.write((RenderedImage)img, "jpg", file);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, e1.getMessage());
                buf = null;
                device.destroy();
            }
        }
        finally {
            buf = null;
            device.destroy();
        }
        return img;
    }

    public BufferedImage getImg1() {
        return this.img1;
    }

    public void setImg1(BufferedImage img1) {
        this.img1 = this.captureImage(this.panel1, this.buf1, img1, this.FRONT);
    }

    public BufferedImage getImg2() {
        return this.img2;
    }

    public void setImg2(BufferedImage img2) {
        this.img2 = this.captureImage(this.panel2, this.buf2, img2, this.FRONT);
    }
}

