/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http5;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericURLFileName;
import org.apache.commons.vfs2.provider.http5.Http5FileContentInfoFactory;
import org.apache.commons.vfs2.provider.http5.Http5FileSystem;
import org.apache.commons.vfs2.provider.http5.Http5FileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.http5.Http5RandomAccessContent;
import org.apache.commons.vfs2.provider.http5.MonitoredHttpResponseContentInputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;

public class Http5FileObject<FS extends Http5FileSystem>
extends AbstractFileObject<FS> {
    private final String urlCharset;
    private final URI internalURI;
    private HttpResponse lastHeadResponse;

    protected Http5FileObject(AbstractFileName name, FS fileSystem) throws FileSystemException {
        this(name, fileSystem, Http5FileSystemConfigBuilder.getInstance());
    }

    protected Http5FileObject(AbstractFileName name, FS fileSystem, Http5FileSystemConfigBuilder builder) throws FileSystemException {
        super(name, fileSystem);
        FileSystemOptions fileSystemOptions = ((AbstractFileSystem)fileSystem).getFileSystemOptions();
        this.urlCharset = builder.getUrlCharset(fileSystemOptions);
        String pathEncoded = ((GenericURLFileName)name).getPathQueryEncoded(this.getUrlCharset());
        this.internalURI = URIUtils.resolve((URI)((Http5FileSystem)fileSystem).getInternalBaseURI(), (String)pathEncoded);
    }

    @Override
    protected void doDetach() throws Exception {
        this.lastHeadResponse = null;
    }

    @Override
    protected long doGetContentSize() throws Exception {
        if (this.lastHeadResponse == null) {
            return 0L;
        }
        Header header = this.lastHeadResponse.getFirstHeader("Content-Length");
        if (header == null) {
            return 0L;
        }
        return Long.parseLong(header.getValue());
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        HttpGet getRequest = new HttpGet(this.getInternalURI());
        ClassicHttpResponse httpResponse = this.executeHttpUriRequest((HttpUriRequest)getRequest);
        int status = httpResponse.getCode();
        if (status == 404) {
            throw new FileNotFoundException(this.getName());
        }
        if (status != 200) {
            throw new FileSystemException("vfs.provider.http/get.error", this.getName(), status);
        }
        return new MonitoredHttpResponseContentInputStream(httpResponse, bufferSize);
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        FileSystemException.requireNonNull(this.lastHeadResponse, "vfs.provider.http/last-modified.error", this.getName());
        Header header = this.lastHeadResponse.getFirstHeader("Last-Modified");
        FileSystemException.requireNonNull(header, "vfs.provider.http/last-modified.error", this.getName());
        return DateUtils.parseDate((String)header.getValue()).getTime();
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new Http5RandomAccessContent(this, mode);
    }

    @Override
    protected FileType doGetType() throws Exception {
        this.lastHeadResponse = this.executeHttpUriRequest((HttpUriRequest)new HttpHead(this.getInternalURI()));
        int status = this.lastHeadResponse.getCode();
        if (status == 200 || status == 405) {
            return FileType.FILE;
        }
        if (status == 404 || status == 410) {
            return FileType.IMAGINARY;
        }
        throw new FileSystemException("vfs.provider.http/head.error", this.getName(), status);
    }

    @Override
    protected boolean doIsWriteable() throws Exception {
        return false;
    }

    @Override
    protected String[] doListChildren() throws Exception {
        throw new UnsupportedOperationException("Not implemented.");
    }

    protected ClassicHttpResponse executeHttpUriRequest(HttpUriRequest httpRequest) throws IOException {
        CloseableHttpClient httpClient = (CloseableHttpClient)((Http5FileSystem)this.getAbstractFileSystem()).getHttpClient();
        HttpClientContext httpClientContext = ((Http5FileSystem)this.getAbstractFileSystem()).getHttpClientContext();
        return httpClient.execute((ClassicHttpRequest)httpRequest, (HttpContext)httpClientContext);
    }

    @Override
    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new Http5FileContentInfoFactory();
    }

    protected URI getInternalURI() {
        return this.internalURI;
    }

    HttpResponse getLastHeadResponse() throws IOException {
        if (this.lastHeadResponse != null) {
            return this.lastHeadResponse;
        }
        return this.executeHttpUriRequest((HttpUriRequest)new HttpHead(this.getInternalURI()));
    }

    protected String getUrlCharset() {
        return this.urlCharset;
    }
}

