/*
 * Decompiled with CFR 0.152.
 */
package com.dynamicode.encrypt;

import java.security.InvalidKeyException;

public class RC4 {
    private static final int STATE_ARRAY_SIZE = 256;
    private byte[] sArray = new byte[256];
    private int x;
    private int y;

    public void engineInit(byte[] key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Null key");
        }
        if (key.length < 1 || key.length > 256) {
            throw new InvalidKeyException("Invalid key length (req. 1-256 bytes " + key.length + ")");
        }
        this.rc4Init(key);
    }

    public byte[] engineCrypt(byte[] in, int inOffset) {
        int outOffset = 0;
        byte[] out = new byte[in.length];
        int i = 0;
        while (i < in.length) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.sArray[this.x] + this.y & 0xFF;
            byte t = this.sArray[this.x];
            this.sArray[this.x] = this.sArray[this.y];
            this.sArray[this.y] = t;
            out[outOffset++] = (byte)(in[inOffset++] ^ this.sArray[this.sArray[this.x] + this.sArray[this.y] & 0xFF]);
            ++i;
        }
        return out;
    }

    public void rc4Init(byte[] key) {
        int i = 0;
        while (i < 256) {
            this.sArray[i] = (byte)i;
            ++i;
        }
        this.x = 0;
        int i2 = 0;
        while (i2 < 256) {
            this.x = (key[i2 % key.length] & 0xFF) + this.sArray[i2] + this.x & 0xFF;
            byte t = this.sArray[i2];
            this.sArray[i2] = this.sArray[this.x];
            this.sArray[this.x] = t;
            ++i2;
        }
        this.y = 0;
        this.x = 0;
    }
}

