/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClobLocatorReader;
import org.apache.derby.client.am.SqlException;

class UpdateSensitiveClobLocatorReader
extends Reader {
    private BufferedReader r = null;
    private ClientConnection con = null;
    private ClientClob clob = null;
    private long updateCount;
    private long currentPos;
    private long length;

    protected UpdateSensitiveClobLocatorReader(ClientConnection clientConnection, ClientClob clientClob) throws SqlException {
        clientClob.checkForLocatorValidity();
        this.r = new BufferedReader(new ClobLocatorReader(clientConnection, clientClob));
        this.currentPos = 1L;
        this.con = clientConnection;
        this.clob = clientClob;
        this.updateCount = clientClob.getUpdateCount();
        this.length = -1L;
    }

    protected UpdateSensitiveClobLocatorReader(ClientConnection clientConnection, ClientClob clientClob, long l, long l2) throws SqlException {
        clientClob.checkForLocatorValidity();
        this.r = new BufferedReader(new ClobLocatorReader(clientConnection, clientClob, l, l2));
        this.con = clientConnection;
        this.clob = clientClob;
        this.currentPos = l;
        this.length = l2;
        this.updateCount = clientClob.getUpdateCount();
    }

    @Override
    public int read() throws IOException {
        this.identifyAndReplaceObseleteStream();
        int n = this.r.read();
        if (n == -1) {
            return n;
        }
        ++this.currentPos;
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.identifyAndReplaceObseleteStream();
        int n3 = this.r.read(cArray, n, n2);
        if (n3 == -1) {
            return n3;
        }
        this.currentPos += (long)n3;
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.r.close();
    }

    private void identifyAndReplaceObseleteStream() throws IOException {
        long l = this.clob.getUpdateCount();
        if (this.updateCount != l) {
            try {
                this.r = new BufferedReader(this.reCreateStream());
            }
            catch (SqlException sqlException) {
                IOException iOException = new IOException();
                iOException.initCause(sqlException);
                throw iOException;
            }
        } else {
            return;
        }
        this.updateCount = l;
    }

    private Reader reCreateStream() throws SqlException {
        ClobLocatorReader clobLocatorReader = null;
        clobLocatorReader = this.length != -1L ? new ClobLocatorReader(this.con, this.clob, this.currentPos, this.length - this.currentPos + 1L) : new ClobLocatorReader(this.con, this.clob, this.currentPos, -1L);
        return clobLocatorReader;
    }
}

