/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPartAltChunkHost;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.BibliographyPart;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsExtendedPart;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.EndnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.openpackaging.parts.WordprocessingML.FootnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.PeoplePart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.WebSettingsPart;
import org.docx4j.openpackaging.parts.opendope.ComponentsPart;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.QuestionsPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.wml.CTEndnotes;
import org.docx4j.wml.CTFootnotes;
import org.docx4j.wml.CTFtnEdn;
import org.docx4j.wml.CTSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DocumentPart<E>
extends JaxbXmlPartAltChunkHost<E> {
    protected static Logger log = LoggerFactory.getLogger(DocumentPart.class);
    protected CommentsPart commentsPart;
    protected CommentsExtendedPart commentsExtendedPart;
    protected DocumentSettingsPart documentSettingsPart;
    protected EndnotesPart endNotesPart;
    protected FontTablePart fontTablePart;
    protected PeoplePart peoplePart;
    protected ThemePart themePart;
    protected FootnotesPart footnotesPart;
    protected NumberingDefinitionsPart numberingDefinitionsPart;
    protected StyleDefinitionsPart styleDefinitionsPart;
    protected WebSettingsPart webSettingsPart;
    private ConditionsPart conditionsPart;
    private XPathsPart xPathsPart;
    private QuestionsPart questionsPart;
    private ComponentsPart componentsPart;
    private BibliographyPart bibliographyPart;

    public boolean setPartShortcut(Part part) {
        if (part == null) {
            return false;
        }
        return this.setPartShortcut(part, part.getRelationshipType());
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType == null) {
            log.warn("trying to set part shortcut against a null relationship type.");
            return false;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable")) {
            this.fontTablePart = (FontTablePart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme")) {
            this.themePart = (ThemePart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles")) {
            this.styleDefinitionsPart = (StyleDefinitionsPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/webSettings")) {
            this.webSettingsPart = (WebSettingsPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings")) {
            this.documentSettingsPart = (DocumentSettingsPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments")) {
            this.commentsPart = (CommentsPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.microsoft.com/office/2011/relationships/commentsExtended")) {
            this.commentsExtendedPart = (CommentsExtendedPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes")) {
            this.endNotesPart = (EndnotesPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes")) {
            this.footnotesPart = (FootnotesPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering")) {
            this.numberingDefinitionsPart = (NumberingDefinitionsPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.microsoft.com/office/2011/relationships/people")) {
            this.peoplePart = (PeoplePart)part;
            return true;
        }
        if (part instanceof ConditionsPart) {
            this.conditionsPart = (ConditionsPart)part;
            return true;
        }
        if (part instanceof QuestionsPart) {
            this.questionsPart = (QuestionsPart)part;
            return true;
        }
        if (part instanceof XPathsPart) {
            this.xPathsPart = (XPathsPart)part;
            return true;
        }
        if (part instanceof ComponentsPart) {
            this.componentsPart = (ComponentsPart)part;
            return true;
        }
        if (part instanceof BibliographyPart) {
            this.bibliographyPart = (BibliographyPart)part;
            return true;
        }
        return false;
    }

    public DocumentPart(PartName partName) throws InvalidFormatException {
        super(partName);
    }

    public CommentsPart getCommentsPart() {
        return this.commentsPart;
    }

    public CommentsExtendedPart getCommentsExtendedPart() {
        return this.commentsExtendedPart;
    }

    public DocumentSettingsPart getDocumentSettingsPart() {
        return this.documentSettingsPart;
    }

    public DocumentSettingsPart getDocumentSettingsPart(boolean createIfAbsent) throws InvalidFormatException {
        if (this.documentSettingsPart == null) {
            if (createIfAbsent) {
                this.documentSettingsPart = new DocumentSettingsPart();
                this.addTargetPart(this.documentSettingsPart);
                this.documentSettingsPart.setContents(new CTSettings());
            } else {
                return null;
            }
        }
        return this.documentSettingsPart;
    }

    public EndnotesPart getEndNotesPart() {
        return this.endNotesPart;
    }

    public boolean hasEndnotesPart() {
        if (this.getEndNotesPart() == null) {
            return false;
        }
        CTEndnotes endnotes = (CTEndnotes)this.getEndNotesPart().getJaxbElement();
        return endnotes.getEndnote().size() >= 3;
    }

    public FootnotesPart getFootnotesPart() {
        return this.footnotesPart;
    }

    public boolean hasFootnotesPart() {
        return this.getFootnotesPart() != null;
    }

    @Deprecated
    public static Node getFootnote(WordprocessingMLPackage wmlPackage, String id) {
        CTFootnotes footnotes = (CTFootnotes)wmlPackage.getMainDocumentPart().getFootnotesPart().getJaxbElement();
        int pos = Integer.parseInt(id);
        CTFtnEdn ftn = footnotes.getFootnote().get(pos);
        Document d = XmlUtils.marshaltoW3CDomDocument(ftn, Context.jc, "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "footnote", CTFtnEdn.class);
        log.debug("Footnote " + id + ": " + XmlUtils.w3CDomNodeToString(d));
        return d;
    }

    public FontTablePart getFontTablePart() {
        return this.fontTablePart;
    }

    public NumberingDefinitionsPart getNumberingDefinitionsPart() {
        return this.numberingDefinitionsPart;
    }

    public PeoplePart getPeoplePart() {
        return this.peoplePart;
    }

    public StyleDefinitionsPart getStyleDefinitionsPart() {
        return this.getStyleDefinitionsPart(false);
    }

    public StyleDefinitionsPart getStyleDefinitionsPart(boolean create) {
        if (this.styleDefinitionsPart == null && create) {
            log.info("No StyleDefinitionsPart detected. Adding default part.");
            try {
                this.styleDefinitionsPart = new StyleDefinitionsPart();
                this.styleDefinitionsPart.unmarshalDefaultStyles();
                this.addTargetPart(this.styleDefinitionsPart);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.styleDefinitionsPart;
    }

    public ThemePart getThemePart() {
        return this.themePart;
    }

    public WebSettingsPart getWebSettingsPart() {
        return this.webSettingsPart;
    }

    public ConditionsPart getConditionsPart() {
        return this.conditionsPart;
    }

    public XPathsPart getXPathsPart() {
        return this.xPathsPart;
    }

    public QuestionsPart getQuestionsPart() {
        return this.questionsPart;
    }

    public ComponentsPart getComponentsPart() {
        return this.componentsPart;
    }

    public BibliographyPart getBibliographyPart() {
        return this.bibliographyPart;
    }
}

