/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.carrotsearch.hppc;

import oadd.com.carrotsearch.hppc.BitMixer;
import oadd.com.carrotsearch.hppc.HashOrderMixing;
import oadd.com.carrotsearch.hppc.ObjectShortHashMap;

public class ObjectShortScatterMap<KType>
extends ObjectShortHashMap<KType> {
    public ObjectShortScatterMap() {
        this(4);
    }

    public ObjectShortScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectShortScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType> ObjectShortScatterMap<KType> from(KType[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectShortScatterMap<KType> map = new ObjectShortScatterMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

