/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica.remote;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import oadd.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import oadd.org.apache.calcite.avatica.remote.ProtobufService;
import oadd.org.apache.calcite.avatica.remote.ProtobufTranslation;
import oadd.org.apache.calcite.avatica.remote.Service;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class RemoteProtobufService
extends ProtobufService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteProtobufService.class);
    private final AvaticaHttpClient client;
    private final ProtobufTranslation translation;

    public RemoteProtobufService(AvaticaHttpClient client, ProtobufTranslation translation) {
        this.client = client;
        this.translation = translation;
    }

    @Override
    public Service.Response _apply(Service.Request request) {
        Service.Response resp;
        byte[] response = null;
        try {
            response = this.client.send(this.translation.serializeRequest(request));
        }
        catch (IOException e) {
            LOG.debug("Failed to execute remote request: {}", (Object)request);
            throw new RuntimeException(e);
        }
        try {
            resp = this.translation.parseResponse(response);
        }
        catch (IOException e) {
            LOG.debug("Failed to deserialize reponse to {}. '{}'", (Object)request, (Object)new String(response, StandardCharsets.UTF_8));
            throw new RuntimeException(e);
        }
        if (resp instanceof Service.ErrorResponse) {
            throw ((Service.ErrorResponse)resp).toException();
        }
        return resp;
    }
}

