/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.dbcp2.managed;

import java.sql.Connection;
import javax.management.ObjectName;
import oadd.org.apache.commons.dbcp2.DelegatingPreparedStatement;
import oadd.org.apache.commons.dbcp2.PStmtKey;
import oadd.org.apache.commons.dbcp2.PoolableConnection;
import oadd.org.apache.commons.dbcp2.PoolableConnectionFactory;
import oadd.org.apache.commons.dbcp2.PoolingConnection;
import oadd.org.apache.commons.dbcp2.managed.PoolableManagedConnection;
import oadd.org.apache.commons.dbcp2.managed.TransactionRegistry;
import oadd.org.apache.commons.dbcp2.managed.XAConnectionFactory;
import oadd.org.apache.commons.pool2.KeyedObjectPool;
import oadd.org.apache.commons.pool2.KeyedPooledObjectFactory;
import oadd.org.apache.commons.pool2.PooledObject;
import oadd.org.apache.commons.pool2.impl.DefaultPooledObject;
import oadd.org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import oadd.org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class PoolableManagedConnectionFactory
extends PoolableConnectionFactory {
    private final TransactionRegistry transactionRegistry;

    public PoolableManagedConnectionFactory(XAConnectionFactory connFactory, ObjectName dataSourceJmxName) {
        super(connFactory, dataSourceJmxName);
        this.transactionRegistry = connFactory.getTransactionRegistry();
    }

    @Override
    public synchronized PooledObject<PoolableConnection> makeObject() throws Exception {
        Connection conn = this.getConnectionFactory().createConnection();
        if (conn == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        this.initializeConnection(conn);
        if (this.getPoolStatements()) {
            conn = new PoolingConnection(conn);
            GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
            config.setMaxTotalPerKey(-1);
            config.setBlockWhenExhausted(false);
            config.setMaxWaitMillis(0L);
            config.setMaxIdlePerKey(1);
            config.setMaxTotal(this.getMaxOpenPreparedStatements());
            ObjectName dataSourceJmxName = this.getDataSourceJmxName();
            long connIndex = this.getConnectionIndex().getAndIncrement();
            if (dataSourceJmxName != null) {
                StringBuilder base = new StringBuilder(dataSourceJmxName.toString());
                base.append(",connectionpool=connections,connection=");
                base.append(Long.toString(connIndex));
                config.setJmxNameBase(base.toString());
                config.setJmxNamePrefix(",statementpool=statements");
            } else {
                config.setJmxEnabled(false);
            }
            GenericKeyedObjectPool stmtPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)((PoolingConnection)conn), config);
            ((PoolingConnection)conn).setStatementPool((KeyedObjectPool<PStmtKey, DelegatingPreparedStatement>)stmtPool);
            ((PoolingConnection)conn).setCacheState(this.getCacheState());
        }
        PoolableManagedConnection pmc = new PoolableManagedConnection(this.transactionRegistry, conn, this.getPool(), this.getDisconnectionSqlCodes(), this.isFastFailValidation());
        pmc.setCacheState(this.getCacheState());
        return new DefaultPooledObject((Object)pmc);
    }
}

