/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.digester;

import java.beans.PropertyDescriptor;
import oadd.org.apache.commons.beanutils.BeanUtils;
import oadd.org.apache.commons.beanutils.DynaBean;
import oadd.org.apache.commons.beanutils.PropertyUtils;
import oadd.org.apache.commons.digester.Digester;
import oadd.org.apache.commons.digester.Rule;
import shade.org.xml.sax.Attributes;

public class SetPropertyRule
extends Rule {
    protected String name = null;
    protected String value = null;

    public SetPropertyRule(Digester digester, String name, String value) {
        this(name, value);
    }

    public SetPropertyRule(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public void begin(Attributes attributes) throws Exception {
        PropertyDescriptor desc;
        String actualName = null;
        String actualValue = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            if ("".equals(name)) {
                name = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            if (name.equals(this.name)) {
                actualName = value;
            } else if (name.equals(this.value)) {
                actualValue = value;
            }
            ++i;
        }
        Object top = this.digester.peek();
        if (this.digester.log.isDebugEnabled()) {
            this.digester.log.debug("[SetPropertyRule]{" + this.digester.match + "} Set " + top.getClass().getName() + " property " + actualName + " to " + actualValue);
        }
        if (top instanceof DynaBean ? (desc = ((DynaBean)top).getDynaClass().getDynaProperty(actualName)) == null : (desc = PropertyUtils.getPropertyDescriptor((Object)top, actualName)) == null) {
            throw new NoSuchMethodException("Bean has no property named " + actualName);
        }
        BeanUtils.setProperty((Object)top, (String)actualName, actualValue);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SetPropertyRule[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(", value=");
        sb.append(this.value);
        sb.append("]");
        return sb.toString();
    }
}

