/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.httpclient.auth;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oadd.org.apache.commons.httpclient.auth.AuthChallengeException;
import oadd.org.apache.commons.httpclient.auth.AuthPolicy;
import oadd.org.apache.commons.httpclient.auth.AuthScheme;
import oadd.org.apache.commons.httpclient.auth.AuthState;
import oadd.org.apache.commons.httpclient.auth.AuthenticationException;
import oadd.org.apache.commons.httpclient.auth.MalformedChallengeException;
import oadd.org.apache.commons.httpclient.params.HttpParams;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;

public final class AuthChallengeProcessor {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$auth$AuthChallengeProcessor == null ? (class$org$apache$commons$httpclient$auth$AuthChallengeProcessor = AuthChallengeProcessor.class$("oadd.org.apache.commons.httpclient.auth.AuthChallengeProcessor")) : class$org$apache$commons$httpclient$auth$AuthChallengeProcessor);
    private HttpParams params = null;
    static /* synthetic */ Class class$org$apache$commons$httpclient$auth$AuthChallengeProcessor;

    public AuthChallengeProcessor(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameter collection may not be null");
        }
        this.params = params;
    }

    public AuthScheme selectAuthScheme(Map challenges) throws AuthChallengeException {
        if (challenges == null) {
            throw new IllegalArgumentException("Challenge map may not be null");
        }
        Collection authPrefs = (Collection)this.params.getParameter("http.auth.scheme-priority");
        if (authPrefs == null || authPrefs.isEmpty()) {
            authPrefs = AuthPolicy.getDefaultAuthPrefs();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supported authentication schemes in the order of preference: " + authPrefs);
        }
        AuthScheme authscheme = null;
        String challenge = null;
        Iterator item = authPrefs.iterator();
        while (item.hasNext()) {
            String id = (String)item.next();
            challenge = (String)challenges.get(id.toLowerCase());
            if (challenge != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(id + " authentication scheme selected");
                }
                try {
                    authscheme = AuthPolicy.getAuthScheme(id);
                    break;
                }
                catch (IllegalStateException e) {
                    throw new AuthChallengeException(e.getMessage());
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Challenge for " + id + " authentication scheme not available");
        }
        if (authscheme == null) {
            throw new AuthChallengeException("Unable to respond to any of these challenges: " + challenges);
        }
        return authscheme;
    }

    public AuthScheme processChallenge(AuthState state, Map challenges) throws MalformedChallengeException, AuthenticationException {
        String challenge;
        if (state == null) {
            throw new IllegalArgumentException("Authentication state may not be null");
        }
        if (challenges == null) {
            throw new IllegalArgumentException("Challenge map may not be null");
        }
        if (state.isPreemptive() || state.getAuthScheme() == null) {
            state.setAuthScheme(this.selectAuthScheme(challenges));
        }
        AuthScheme authscheme = state.getAuthScheme();
        String id = authscheme.getSchemeName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using authentication scheme: " + id);
        }
        if ((challenge = (String)challenges.get(id.toLowerCase())) == null) {
            throw new AuthenticationException(id + " authorization challenge expected, but not found");
        }
        authscheme.processChallenge(challenge);
        LOG.debug("Authorization challenge processed");
        return authscheme;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

