/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.x.discovery.details;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.collect.ImmutableList;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Maps;
import oadd.com.google.common.collect.Sets;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import oadd.org.apache.curator.framework.api.BackgroundPathable;
import oadd.org.apache.curator.framework.recipes.cache.NodeCache;
import oadd.org.apache.curator.framework.recipes.cache.NodeCacheListener;
import oadd.org.apache.curator.framework.state.ConnectionState;
import oadd.org.apache.curator.framework.state.ConnectionStateListener;
import oadd.org.apache.curator.utils.CloseableUtils;
import oadd.org.apache.curator.utils.ThreadUtils;
import oadd.org.apache.curator.utils.ZKPaths;
import oadd.org.apache.curator.x.discovery.ServiceCache;
import oadd.org.apache.curator.x.discovery.ServiceCacheBuilder;
import oadd.org.apache.curator.x.discovery.ServiceDiscovery;
import oadd.org.apache.curator.x.discovery.ServiceInstance;
import oadd.org.apache.curator.x.discovery.ServiceProvider;
import oadd.org.apache.curator.x.discovery.ServiceProviderBuilder;
import oadd.org.apache.curator.x.discovery.ServiceType;
import oadd.org.apache.curator.x.discovery.details.InstanceSerializer;
import oadd.org.apache.curator.x.discovery.details.ServiceCacheBuilderImpl;
import oadd.org.apache.curator.x.discovery.details.ServiceProviderBuilderImpl;
import oadd.org.apache.curator.x.discovery.strategies.RoundRobinStrategy;
import oadd.org.apache.zookeeper.CreateMode;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.Watcher;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class ServiceDiscoveryImpl<T>
implements ServiceDiscovery<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final String basePath;
    private final InstanceSerializer<T> serializer;
    private final Map<String, ServiceInstance<T>> services = Maps.newConcurrentMap();
    private final Map<String, NodeCache> watchedServices;
    private final Collection<ServiceCache<T>> caches = Sets.newSetFromMap(Maps.newConcurrentMap());
    private final Collection<ServiceProvider<T>> providers = Sets.newSetFromMap(Maps.newConcurrentMap());
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.RECONNECTED || newState == ConnectionState.CONNECTED) {
                try {
                    ServiceDiscoveryImpl.this.log.debug("Re-registering due to reconnection");
                    ServiceDiscoveryImpl.this.reRegisterServices();
                }
                catch (Exception e) {
                    ServiceDiscoveryImpl.this.log.error("Could not re-register instances after reconnection", e);
                }
            }
        }
    };

    public ServiceDiscoveryImpl(CuratorFramework client, String basePath, InstanceSerializer<T> serializer, ServiceInstance<T> thisInstance, boolean watchInstances) {
        this.client = Preconditions.checkNotNull(client, "client cannot be null");
        this.basePath = Preconditions.checkNotNull(basePath, "basePath cannot be null");
        this.serializer = Preconditions.checkNotNull(serializer, "serializer cannot be null");
        Map<String, NodeCache> map = this.watchedServices = watchInstances ? Maps.newConcurrentMap() : null;
        if (thisInstance != null) {
            this.setService(thisInstance);
        }
    }

    @Override
    public void start() throws Exception {
        try {
            this.reRegisterServices();
        }
        catch (KeeperException e) {
            this.log.error("Could not register instances - will try again later", e);
        }
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
    }

    @Override
    public void close() throws IOException {
        for (ServiceCache<T> serviceCache : Lists.newArrayList(this.caches)) {
            CloseableUtils.closeQuietly(serviceCache);
        }
        for (ServiceProvider serviceProvider : Lists.newArrayList(this.providers)) {
            CloseableUtils.closeQuietly(serviceProvider);
        }
        if (this.watchedServices != null) {
            for (NodeCache nodeCache : this.watchedServices.values()) {
                CloseableUtils.closeQuietly(nodeCache);
            }
        }
        Iterator<ServiceInstance<T>> it = this.services.values().iterator();
        while (it.hasNext()) {
            ServiceInstance<T> serviceInstance = it.next();
            String path = this.pathForInstance(serviceInstance.getName(), serviceInstance.getId());
            boolean doRemove = true;
            try {
                this.client.delete().forPath(path);
            }
            catch (KeeperException.NoNodeException ignore) {
            }
            catch (Exception e) {
                doRemove = false;
                this.log.error("Could not unregister instance: " + serviceInstance.getName(), e);
            }
            if (!doRemove) continue;
            it.remove();
        }
        this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
    }

    @Override
    public void registerService(ServiceInstance<T> service) throws Exception {
        this.setService(service);
        this.internalRegisterService(service);
    }

    @Override
    public void updateService(ServiceInstance<T> service) throws Exception {
        byte[] bytes = this.serializer.serialize(service);
        String path = this.pathForInstance(service.getName(), service.getId());
        this.client.setData().forPath(path, bytes);
        this.services.put(service.getId(), service);
    }

    @VisibleForTesting
    protected void internalRegisterService(ServiceInstance<T> service) throws Exception {
        byte[] bytes = this.serializer.serialize(service);
        String path = this.pathForInstance(service.getName(), service.getId());
        int MAX_TRIES = 2;
        boolean isDone = false;
        for (int i = 0; !isDone && i < 2; ++i) {
            try {
                CreateMode mode = service.getServiceType() == ServiceType.DYNAMIC ? CreateMode.EPHEMERAL : CreateMode.PERSISTENT;
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(mode)).forPath(path, bytes);
                isDone = true;
                continue;
            }
            catch (KeeperException.NodeExistsException e) {
                this.client.delete().forPath(path);
            }
        }
    }

    @Override
    public void unregisterService(ServiceInstance<T> service) throws Exception {
        String path = this.pathForInstance(service.getName(), service.getId());
        try {
            this.client.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        this.services.remove(service.getId());
    }

    @Override
    public ServiceProviderBuilder<T> serviceProviderBuilder() {
        return new ServiceProviderBuilderImpl(this).providerStrategy(new RoundRobinStrategy()).threadFactory(ThreadUtils.newThreadFactory("ServiceProvider"));
    }

    @Override
    public ServiceCacheBuilder<T> serviceCacheBuilder() {
        return new ServiceCacheBuilderImpl(this).threadFactory(ThreadUtils.newThreadFactory("ServiceCache"));
    }

    @Override
    public Collection<String> queryForNames() throws Exception {
        List names = (List)this.client.getChildren().forPath(this.basePath);
        return ImmutableList.copyOf(names);
    }

    @Override
    public Collection<ServiceInstance<T>> queryForInstances(String name) throws Exception {
        return this.queryForInstances(name, null);
    }

    @Override
    public ServiceInstance<T> queryForInstance(String name, String id) throws Exception {
        String path = this.pathForInstance(name, id);
        try {
            byte[] bytes = (byte[])this.client.getData().forPath(path);
            return this.serializer.deserialize(bytes);
        }
        catch (KeeperException.NoNodeException ignore) {
            return null;
        }
    }

    void cacheOpened(ServiceCache<T> cache) {
        this.caches.add(cache);
    }

    void cacheClosed(ServiceCache<T> cache) {
        this.caches.remove(cache);
    }

    void providerOpened(ServiceProvider<T> provider) {
        this.providers.add(provider);
    }

    void providerClosed(ServiceProvider<T> cache) {
        this.providers.remove(cache);
    }

    CuratorFramework getClient() {
        return this.client;
    }

    String pathForName(String name) {
        return ZKPaths.makePath(this.basePath, name);
    }

    InstanceSerializer<T> getSerializer() {
        return this.serializer;
    }

    List<ServiceInstance<T>> queryForInstances(String name, Watcher watcher) throws Exception {
        List<Object> instanceIds;
        ImmutableList.Builder builder = ImmutableList.builder();
        String path = this.pathForName(name);
        if (watcher != null) {
            instanceIds = this.getChildrenWatched(path, watcher, true);
        } else {
            try {
                instanceIds = (List)this.client.getChildren().forPath(path);
            }
            catch (KeeperException.NoNodeException e) {
                instanceIds = Lists.newArrayList();
            }
        }
        for (String string : instanceIds) {
            ServiceInstance<T> instance = this.queryForInstance(name, string);
            if (instance == null) continue;
            builder.add(instance);
        }
        return builder.build();
    }

    private List<String> getChildrenWatched(String path, Watcher watcher, boolean recurse) throws Exception {
        List<String> instanceIds;
        try {
            instanceIds = (List<String>)((BackgroundPathable)this.client.getChildren().usingWatcher(watcher)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            if (recurse) {
                try {
                    this.client.create().creatingParentsIfNeeded().forPath(path);
                }
                catch (KeeperException.NodeExistsException ignore) {
                    // empty catch block
                }
                instanceIds = this.getChildrenWatched(path, watcher, false);
            }
            throw e;
        }
        return instanceIds;
    }

    @VisibleForTesting
    String pathForInstance(String name, String id) {
        return ZKPaths.makePath(this.pathForName(name), id);
    }

    @VisibleForTesting
    ServiceInstance<T> getRegisteredService(String id) {
        return this.services.get(id);
    }

    private void reRegisterServices() throws Exception {
        for (ServiceInstance<T> service : this.services.values()) {
            this.internalRegisterService(service);
        }
    }

    private void setService(final ServiceInstance<T> instance) {
        this.services.put(instance.getId(), instance);
        if (this.watchedServices != null) {
            final NodeCache nodeCache = new NodeCache(this.client, this.pathForInstance(instance.getName(), instance.getId()));
            try {
                nodeCache.start(true);
            }
            catch (Exception e) {
                this.log.error("Could not start node cache for: " + instance, e);
            }
            NodeCacheListener listener = new NodeCacheListener(){

                @Override
                public void nodeChanged() throws Exception {
                    if (nodeCache.getCurrentData() != null) {
                        ServiceInstance newInstance = ServiceDiscoveryImpl.this.serializer.deserialize(nodeCache.getCurrentData().getData());
                        ServiceDiscoveryImpl.this.services.put(newInstance.getId(), newInstance);
                    } else {
                        ServiceDiscoveryImpl.this.log.warn("Instance data has been deleted for: " + instance);
                    }
                }
            };
            nodeCache.getListenable().addListener(listener);
            this.watchedServices.put(instance.getId(), nodeCache);
        }
    }
}

