/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common;

import java.util.Arrays;

public class StackTrace {
    private final StackTraceElement[] stackTraceElements;

    public StackTrace() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        this.stackTraceElements = Arrays.copyOfRange(stack, 1, stack.length - 1);
    }

    public void writeToBuilder(StringBuilder sb, int indent) {
        char[] indentation = new char[indent * 2];
        Arrays.fill(indentation, ' ');
        for (StackTraceElement ste : this.stackTraceElements) {
            sb.append(indentation).append("at ").append(ste.getClassName()).append('.').append(ste.getMethodName()).append('(').append(ste.getFileName()).append(':').append(Integer.toString(ste.getLineNumber())).append(")\n");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.writeToBuilder(sb, 0);
        return sb.toString();
    }
}

