/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.config;

import java.util.Set;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.SerializationFeature;
import oadd.com.fasterxml.jackson.databind.module.SimpleModule;
import oadd.com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.logical.FormatPluginConfigBase;
import oadd.org.apache.drill.common.logical.StoragePluginConfigBase;
import oadd.org.apache.drill.common.logical.data.LogicalOperatorBase;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;

public class LogicalPlanPersistence {
    private final ObjectMapper mapper;

    public LogicalPlanPersistence(DrillConfig conf, ScanResult scanResult) {
        this(conf, scanResult, new ObjectMapper());
    }

    public LogicalPlanPersistence(DrillConfig conf, ScanResult scanResult, ObjectMapper mapper) {
        this.mapper = mapper;
        SimpleModule deserModule = new SimpleModule("LogicalExpressionDeserializationModule").addDeserializer(LogicalExpression.class, new LogicalExpression.De(conf)).addDeserializer(SchemaPath.class, new SchemaPath.De());
        mapper.registerModule(deserModule);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.setFilterProvider(new SimpleFilterProvider().setFailOnUnknownId(false));
        this.registerSubtypes(LogicalOperatorBase.getSubTypes(scanResult));
        this.registerSubtypes(StoragePluginConfigBase.getSubTypes(scanResult));
        this.registerSubtypes(FormatPluginConfigBase.getSubTypes(scanResult));
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private <T> void registerSubtypes(Set<Class<? extends T>> types) {
        for (Class<T> clazz : types) {
            this.mapper.registerSubtypes(clazz);
        }
    }
}

