/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.util;

import java.lang.reflect.Constructor;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class ConstructorChecker {
    static final Logger logger = LoggerFactory.getLogger(ConstructorChecker.class);
    private final String requirementString;
    private final Class<?>[] classes;

    public ConstructorChecker(Class<?> ... classes) {
        this.classes = classes;
        StringBuffer sb = new StringBuffer();
        sb.append("The required constructor is (");
        for (int i = 0; i < classes.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(classes[i].getName());
        }
        this.requirementString = sb.toString();
    }

    public boolean check(Constructor<?> c) {
        Class<?>[] params = c.getParameterTypes();
        if (params.length != this.classes.length) {
            return false;
        }
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i].isAssignableFrom(params[i])) continue;
            return false;
        }
        return true;
    }

    public String getRequirementString() {
        return this.requirementString;
    }
}

