/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.zk;

import java.lang.reflect.Constructor;
import java.util.Set;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.scanner.persistence.ScanResult;
import oadd.org.apache.drill.exec.coord.zk.ZKACLContextProvider;
import oadd.org.apache.drill.exec.coord.zk.ZKACLContextProviderImpl;
import oadd.org.apache.drill.exec.coord.zk.ZKACLProvider;
import oadd.org.apache.drill.exec.coord.zk.ZKACLProviderDelegate;
import oadd.org.apache.drill.exec.coord.zk.ZKACLProviderTemplate;
import oadd.org.apache.drill.exec.coord.zk.ZKDefaultACLProvider;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class ZKACLProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(ZKACLProviderFactory.class);

    public static ZKACLProviderDelegate getACLProvider(DrillConfig config, String drillClusterPath, BootStrapContext context) throws DrillbitStartupException {
        ZKACLContextProviderImpl stateProvider = new ZKACLContextProviderImpl(drillClusterPath);
        if (config.getBoolean("drill.exec.zk.apply_secure_acl")) {
            logger.trace("Using secure ZK ACL. Drill cluster path " + drillClusterPath);
            ZKACLProviderDelegate aclProvider = ZKACLProviderFactory.findACLProvider(config, stateProvider, context);
            return aclProvider;
        }
        logger.trace("Using un-secure default ZK ACL");
        ZKDefaultACLProvider defaultAclProvider = new ZKDefaultACLProvider(stateProvider);
        return new ZKACLProviderDelegate(defaultAclProvider);
    }

    public static ZKACLProviderDelegate findACLProvider(DrillConfig config, ZKACLContextProvider contextProvider, BootStrapContext context) throws DrillbitStartupException {
        if (!config.hasPath("drill.exec.zk.acl_provider")) {
            throw new DrillbitStartupException(String.format("BOOT option '%s' is missing in config.", "drill.exec.zk.acl_provider"));
        }
        String aclProviderName = config.getString("drill.exec.zk.acl_provider");
        if (Strings.isNullOrEmpty(aclProviderName)) {
            throw new DrillbitStartupException(String.format("Invalid value '%s' for BOOT option '%s'", aclProviderName, "drill.exec.zk.acl_provider"));
        }
        ScanResult scan = context.getClasspathScan();
        Set<Class<ZKACLProvider>> aclProviderImpls = scan.getImplementations(ZKACLProvider.class);
        logger.debug("Found ZkACLProvider implementations: {}", (Object)aclProviderImpls);
        for (Class clazz : aclProviderImpls) {
            ZKACLProviderTemplate template = clazz.getAnnotation(ZKACLProviderTemplate.class);
            if (template == null) {
                logger.warn("{} doesn't have {} annotation. Skipping.", (Object)clazz.getCanonicalName(), (Object)ZKACLProviderTemplate.class);
                continue;
            }
            if (!template.type().equalsIgnoreCase(aclProviderName)) continue;
            Constructor<?> validConstructor = null;
            Class<ZKACLContextProvider> constructorArgumentClass = ZKACLContextProvider.class;
            for (Constructor<?> c : clazz.getConstructors()) {
                Class<?>[] params = c.getParameterTypes();
                if (params.length != 1 || params[0] != constructorArgumentClass) continue;
                validConstructor = c;
                break;
            }
            if (validConstructor == null) {
                logger.warn("Skipping ZKACLProvider implementation class '{}' since it doesn't implement a constructor [{}({})]", clazz.getCanonicalName(), clazz.getName(), constructorArgumentClass.getName());
                continue;
            }
            try {
                ZKACLProvider aclProvider = (ZKACLProvider)validConstructor.newInstance(contextProvider);
                return new ZKACLProviderDelegate(aclProvider);
            }
            catch (ReflectiveOperationException e) {
                throw new DrillbitStartupException(String.format("Failed to create and initialize the ZKACLProvider class '%s'", clazz.getCanonicalName()), e);
            }
        }
        String errMsg = String.format("Failed to find the implementation of '%s' for type '%s'", ZKACLProvider.class.getCanonicalName(), aclProviderName);
        logger.error(errMsg);
        throw new DrillbitStartupException(errMsg);
    }
}

