/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.zk;

import java.util.List;
import oadd.org.apache.drill.exec.coord.zk.ZKACLContextProvider;
import oadd.org.apache.drill.exec.coord.zk.ZKACLProvider;
import oadd.org.apache.drill.exec.coord.zk.ZKACLProviderTemplate;
import oadd.org.apache.zookeeper.ZooDefs;
import oadd.org.apache.zookeeper.data.ACL;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

@ZKACLProviderTemplate(type="creator-all")
public class ZKSecureACLProvider
implements ZKACLProvider {
    static final Logger logger = LoggerFactory.getLogger(ZKSecureACLProvider.class);
    private static final ImmutableList<ACL> DEFAULT_ACL = ((ImmutableList.Builder)new ImmutableList.Builder().addAll(ZooDefs.Ids.CREATOR_ALL_ACL.iterator())).build();
    private static final ImmutableList<ACL> DRILL_CLUSTER_ACL = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(ZooDefs.Ids.READ_ACL_UNSAFE.iterator())).addAll(ZooDefs.Ids.CREATOR_ALL_ACL.iterator())).build();
    final String drillClusterPath;

    public ZKSecureACLProvider(ZKACLContextProvider contextProvider) {
        this.drillClusterPath = contextProvider.getClusterPath();
    }

    @Override
    public List<ACL> getDrillDefaultAcl() {
        return DEFAULT_ACL;
    }

    @Override
    public List<ACL> getDrillAclForPath(String path) {
        logger.trace("getAclForPath " + path);
        if (path.startsWith(this.drillClusterPath)) {
            logger.trace("getAclForPath drillClusterPath " + this.drillClusterPath);
            return DRILL_CLUSTER_ACL;
        }
        return DEFAULT_ACL;
    }
}

