/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.zk;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import oadd.org.apache.drill.common.collections.ImmutableEntry;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.coord.store.BaseTransientStore;
import oadd.org.apache.drill.exec.coord.store.TransientStoreConfig;
import oadd.org.apache.drill.exec.coord.store.TransientStoreEvent;
import oadd.org.apache.drill.exec.coord.zk.EventDispatcher;
import oadd.org.apache.drill.exec.coord.zk.PathUtils;
import oadd.org.apache.drill.exec.coord.zk.ZookeeperClient;
import oadd.org.apache.drill.exec.serialization.InstanceSerializer;
import oadd.org.apache.zookeeper.CreateMode;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Function;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterators;
import shade.javax.annotation.Nullable;

public class ZkEphemeralStore<V>
extends BaseTransientStore<V> {
    @VisibleForTesting
    protected final PathChildrenCacheListener dispatcher = new EventDispatcher(this);
    private final ZookeeperClient client;

    public ZkEphemeralStore(TransientStoreConfig<V> config, CuratorFramework curator) {
        super(config);
        this.client = new ZookeeperClient(curator, PathUtils.join("/", config.getName()), CreateMode.EPHEMERAL);
    }

    public void start() throws Exception {
        this.getClient().getCache().getListenable().addListener(this.dispatcher);
        this.getClient().start();
    }

    protected ZookeeperClient getClient() {
        return this.client;
    }

    @Override
    public V get(String key) {
        byte[] bytes = this.getClient().get(key);
        if (bytes == null) {
            return null;
        }
        try {
            return this.config.getSerializer().deserialize(bytes);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(String.format("unable to deserialize value at %s", key), e);
        }
    }

    @Override
    public V put(String key, V value) {
        InstanceSerializer serializer = this.config.getSerializer();
        try {
            byte[] old = this.getClient().get(key);
            byte[] bytes = serializer.serialize(value);
            this.getClient().put(key, bytes);
            if (old == null) {
                return null;
            }
            return serializer.deserialize(old);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(String.format("unable to de/serialize value of type %s", value.getClass()), e);
        }
    }

    @Override
    public V putIfAbsent(String key, V value) {
        try {
            InstanceSerializer serializer = this.config.getSerializer();
            byte[] bytes = serializer.serialize(value);
            byte[] data = this.getClient().putIfAbsent(key, bytes);
            if (data == null) {
                return null;
            }
            return serializer.deserialize(data);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(String.format("unable to serialize value of type %s", value.getClass()), e);
        }
    }

    @Override
    public V remove(String key) {
        V existing = this.get(key);
        if (existing != null) {
            this.getClient().delete(key);
        }
        return existing;
    }

    @Override
    public Iterator<Map.Entry<String, V>> entries() {
        return Iterators.transform(this.getClient().entries(), new Function<Map.Entry<String, byte[]>, Map.Entry<String, V>>(){

            @Override
            @Nullable
            public Map.Entry<String, V> apply(@Nullable Map.Entry<String, byte[]> input) {
                try {
                    Object value = ZkEphemeralStore.this.config.getSerializer().deserialize(input.getValue());
                    return new ImmutableEntry(input.getKey(), value);
                }
                catch (IOException e) {
                    throw new DrillRuntimeException(String.format("unable to deserialize value at key %s", input.getKey()), e);
                }
            }
        });
    }

    @Override
    public int size() {
        return this.getClient().getCache().getCurrentData().size();
    }

    @Override
    public void close() throws Exception {
        this.getClient().close();
    }

    @Override
    protected void fireListeners(TransientStoreEvent event) {
        super.fireListeners(event);
    }
}

