/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.ClassGenerator;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class GetSetVectorHelper {
    static final Logger logger = LoggerFactory.getLogger(GetSetVectorHelper.class);

    public static void read(TypeProtos.MajorType type, JExpression vector, JBlock eval, ClassGenerator.HoldingContainer out, JCodeModel model, JExpression indexVariable) {
        JInvocation getValueAccessor = vector.invoke("getAccessor");
        switch (type.getMode()) {
            case OPTIONAL: {
                eval.assign((JAssignmentTarget)out.getIsSet(), (JExpression)getValueAccessor.invoke("isSet").arg(indexVariable));
                eval = eval._if(out.getIsSet().eq(JExpr.lit((int)1)))._then();
            }
            case REQUIRED: {
                switch (type.getMinorType()) {
                    case BIGINT: 
                    case FLOAT4: 
                    case FLOAT8: 
                    case INT: 
                    case MONEY: 
                    case SMALLINT: 
                    case TINYINT: 
                    case UINT1: 
                    case UINT2: 
                    case UINT4: 
                    case UINT8: 
                    case INTERVALYEAR: 
                    case DATE: 
                    case TIME: 
                    case TIMESTAMP: 
                    case BIT: {
                        eval.assign((JAssignmentTarget)out.getValue(), (JExpression)getValueAccessor.invoke("get").arg(indexVariable));
                        return;
                    }
                    case DECIMAL9: 
                    case DECIMAL18: {
                        eval.assign((JAssignmentTarget)out.getHolder().ref("scale"), (JExpression)vector.invoke("getField").invoke("getScale"));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("precision"), (JExpression)vector.invoke("getField").invoke("getPrecision"));
                        eval.assign((JAssignmentTarget)out.getValue(), (JExpression)getValueAccessor.invoke("get").arg(indexVariable));
                        return;
                    }
                    case DECIMAL28DENSE: 
                    case DECIMAL28SPARSE: 
                    case DECIMAL38DENSE: 
                    case DECIMAL38SPARSE: {
                        eval.assign((JAssignmentTarget)out.getHolder().ref("scale"), (JExpression)vector.invoke("getField").invoke("getScale"));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("precision"), (JExpression)vector.invoke("getField").invoke("getPrecision"));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("start"), JExpr.lit((int)TypeHelper.getSize(type)).mul(indexVariable));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("buffer"), (JExpression)vector.invoke("getBuffer"));
                        return;
                    }
                    case VARDECIMAL: {
                        eval.assign((JAssignmentTarget)out.getHolder().ref("buffer"), (JExpression)vector.invoke("getBuffer"));
                        JVar se = eval.decl((JType)model.LONG, "startEnd", (JExpression)getValueAccessor.invoke("getStartEnd").arg(indexVariable));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("start"), (JExpression)JExpr.cast((JType)model._ref(Integer.TYPE), (JExpression)se));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("end"), (JExpression)JExpr.cast((JType)model._ref(Integer.TYPE), (JExpression)se.shr(JExpr.lit((int)32))));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("scale"), (JExpression)vector.invoke("getField").invoke("getScale"));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("precision"), (JExpression)vector.invoke("getField").invoke("getPrecision"));
                        return;
                    }
                    case INTERVAL: {
                        JVar start = eval.decl((JType)model.INT, "start", JExpr.lit((int)TypeHelper.getSize(type)).mul(indexVariable));
                        JVar data = eval.decl((JType)model.ref(DrillBuf.class), "data", (JExpression)vector.invoke("getBuffer"));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("months"), (JExpression)data.invoke("getInt").arg((JExpression)start));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("days"), (JExpression)data.invoke("getInt").arg(start.plus(JExpr.lit((int)4))));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("milliseconds"), (JExpression)data.invoke("getInt").arg(start.plus(JExpr.lit((int)8))));
                        return;
                    }
                    case INTERVALDAY: {
                        JVar start = eval.decl((JType)model.INT, "start", JExpr.lit((int)TypeHelper.getSize(type)).mul(indexVariable));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("days"), (JExpression)vector.invoke("getBuffer").invoke("getInt").arg((JExpression)start));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("milliseconds"), (JExpression)vector.invoke("getBuffer").invoke("getInt").arg(start.plus(JExpr.lit((int)4))));
                        return;
                    }
                    case VAR16CHAR: 
                    case VARBINARY: 
                    case VARCHAR: {
                        eval.assign((JAssignmentTarget)out.getHolder().ref("buffer"), (JExpression)vector.invoke("getBuffer"));
                        JVar se = eval.decl((JType)model.LONG, "startEnd", (JExpression)getValueAccessor.invoke("getStartEnd").arg(indexVariable));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("start"), (JExpression)JExpr.cast((JType)model._ref(Integer.TYPE), (JExpression)se));
                        eval.assign((JAssignmentTarget)out.getHolder().ref("end"), (JExpression)JExpr.cast((JType)model._ref(Integer.TYPE), (JExpression)se.shr(JExpr.lit((int)32))));
                        return;
                    }
                }
            }
        }
        eval.add((JStatement)getValueAccessor.invoke("get").arg(indexVariable).arg((JExpression)out.getHolder()));
    }

    public static JInvocation write(TypeProtos.MajorType type, JVar vector, ClassGenerator.HoldingContainer in, JExpression indexVariable, String setMethodName) {
        JInvocation setMethod = vector.invoke("getMutator").invoke(setMethodName).arg(indexVariable);
        if (type.getMinorType() == TypeProtos.MinorType.UNION) {
            return setMethod.arg((JExpression)in.getHolder());
        }
        switch (type.getMode()) {
            case OPTIONAL: {
                setMethod = setMethod.arg((JExpression)in.f("isSet"));
            }
            case REQUIRED: {
                switch (type.getMinorType()) {
                    case BIGINT: 
                    case FLOAT4: 
                    case FLOAT8: 
                    case INT: 
                    case MONEY: 
                    case SMALLINT: 
                    case TINYINT: 
                    case UINT1: 
                    case UINT2: 
                    case UINT4: 
                    case UINT8: 
                    case INTERVALYEAR: 
                    case DATE: 
                    case TIME: 
                    case TIMESTAMP: 
                    case BIT: 
                    case DECIMAL9: 
                    case DECIMAL18: {
                        return setMethod.arg((JExpression)in.getValue());
                    }
                    case DECIMAL28DENSE: 
                    case DECIMAL28SPARSE: 
                    case DECIMAL38DENSE: 
                    case DECIMAL38SPARSE: {
                        return setMethod.arg((JExpression)in.f("start")).arg((JExpression)in.f("buffer"));
                    }
                    case INTERVAL: {
                        return setMethod.arg((JExpression)in.f("months")).arg((JExpression)in.f("days")).arg((JExpression)in.f("milliseconds"));
                    }
                    case INTERVALDAY: {
                        return setMethod.arg((JExpression)in.f("days")).arg((JExpression)in.f("milliseconds"));
                    }
                    case VARDECIMAL: 
                    case VAR16CHAR: 
                    case VARBINARY: 
                    case VARCHAR: {
                        return setMethod.arg((JExpression)in.f("start")).arg((JExpression)in.f("end")).arg((JExpression)in.f("buffer"));
                    }
                }
            }
        }
        return setMethod.arg((JExpression)in.getHolder());
    }
}

