/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oadd.org.apache.drill.exec.ops.MetricDef;
import oadd.org.apache.drill.exec.physical.impl.ScreenCreator;
import oadd.org.apache.drill.exec.physical.impl.SingleSenderCreator;
import oadd.org.apache.drill.exec.physical.impl.aggregate.HashAggTemplate;
import oadd.org.apache.drill.exec.physical.impl.broadcastsender.BroadcastSenderRootExec;
import oadd.org.apache.drill.exec.physical.impl.filter.RuntimeFilterRecordBatch;
import oadd.org.apache.drill.exec.physical.impl.flatten.FlattenRecordBatch;
import oadd.org.apache.drill.exec.physical.impl.join.HashJoinBatch;
import oadd.org.apache.drill.exec.physical.impl.mergereceiver.MergingRecordBatch;
import oadd.org.apache.drill.exec.physical.impl.partitionsender.PartitionSenderRootExec;
import oadd.org.apache.drill.exec.physical.impl.unnest.UnnestRecordBatch;
import oadd.org.apache.drill.exec.physical.impl.unorderedreceiver.UnorderedReceiverBatch;
import oadd.org.apache.drill.exec.physical.impl.xsort.ExternalSortBatch;
import oadd.org.apache.drill.exec.record.AbstractBinaryRecordBatch;
import oadd.org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;

public class OperatorMetricRegistry {
    private static final Map<Integer, String[]> OPERATOR_METRICS = new HashMap<Integer, String[]>();

    private static void register(int operatorType, Class<? extends MetricDef> metricDef) {
        MetricDef[] enumConstants = metricDef.getEnumConstants();
        if (enumConstants != null) {
            String[] names = (String[])Arrays.stream(enumConstants).map(MetricDef::name).toArray(String[]::new);
            OPERATOR_METRICS.put(operatorType, names);
        }
    }

    public static String[] getMetricNames(int operatorType) {
        return OPERATOR_METRICS.get(operatorType);
    }

    private OperatorMetricRegistry() {
    }

    static {
        OperatorMetricRegistry.register(13, ScreenCreator.ScreenRoot.Metric.class);
        OperatorMetricRegistry.register(0, SingleSenderCreator.SingleSenderRootExec.Metric.class);
        OperatorMetricRegistry.register(1, BroadcastSenderRootExec.Metric.class);
        OperatorMetricRegistry.register(6, PartitionSenderRootExec.Metric.class);
        OperatorMetricRegistry.register(8, MergingRecordBatch.Metric.class);
        OperatorMetricRegistry.register(11, UnorderedReceiverBatch.Metric.class);
        OperatorMetricRegistry.register(3, HashAggTemplate.Metric.class);
        OperatorMetricRegistry.register(4, HashJoinBatch.Metric.class);
        OperatorMetricRegistry.register(17, ExternalSortBatch.Metric.class);
        OperatorMetricRegistry.register(21, ParquetRecordReader.Metric.class);
        OperatorMetricRegistry.register(40, FlattenRecordBatch.Metric.class);
        OperatorMetricRegistry.register(5, AbstractBinaryRecordBatch.Metric.class);
        OperatorMetricRegistry.register(41, AbstractBinaryRecordBatch.Metric.class);
        OperatorMetricRegistry.register(42, UnnestRecordBatch.Metric.class);
        OperatorMetricRegistry.register(19, AbstractBinaryRecordBatch.Metric.class);
        OperatorMetricRegistry.register(56, RuntimeFilterRecordBatch.Metric.class);
    }
}

