/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import oadd.com.carrotsearch.hppc.ObjectIntHashMap;
import oadd.org.apache.calcite.schema.SchemaPlus;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class ViewExpansionContext {
    private static final Logger logger = LoggerFactory.getLogger(ViewExpansionContext.class);
    private final SchemaConfig.SchemaConfigInfoProvider schemaConfigInfoProvider;
    private final int maxChainedUserHops;
    private final String queryUser;
    private final ObjectIntHashMap<String> userTokens = new ObjectIntHashMap();
    private final boolean impersonationEnabled;

    public ViewExpansionContext(QueryContext queryContext) {
        this(queryContext.getConfig(), queryContext);
    }

    public ViewExpansionContext(DrillConfig config, SchemaConfig.SchemaConfigInfoProvider schemaConfigInfoProvider) {
        this.schemaConfigInfoProvider = schemaConfigInfoProvider;
        this.maxChainedUserHops = config.getInt("drill.exec.impersonation.max_chained_user_hops");
        this.queryUser = schemaConfigInfoProvider.getQueryUserName();
        this.impersonationEnabled = config.getBoolean("drill.exec.impersonation.enabled");
    }

    public boolean isImpersonationEnabled() {
        return this.impersonationEnabled;
    }

    public ViewExpansionToken reserveViewExpansionToken(String viewOwner) {
        int totalTokens = 1;
        if (!viewOwner.equals(this.queryUser)) {
            if (this.userTokens.containsKey(viewOwner)) {
                totalTokens += this.userTokens.get(viewOwner);
            } else if (this.userTokens.size() == this.maxChainedUserHops) {
                String errMsg = String.format("Cannot issue token for view expansion as issuing the token exceeds the maximum allowed number of user hops (%d) in chained impersonation.", this.maxChainedUserHops);
                logger.error(errMsg);
                throw UserException.permissionError().message(errMsg, new Object[0]).build(logger);
            }
            this.userTokens.put(viewOwner, totalTokens);
            logger.debug("Issued view expansion token for user '{}'", (Object)viewOwner);
        }
        return new ViewExpansionToken(viewOwner);
    }

    private void releaseViewExpansionToken(ViewExpansionToken token) {
        String viewOwner = token.viewOwner;
        if (viewOwner.equals(this.queryUser)) {
            return;
        }
        Preconditions.checkState(this.userTokens.containsKey(token.viewOwner), "Given user doesn't exist in User Token store. Make sure token for this user is obtained first.");
        int userTokenCount = this.userTokens.get(viewOwner);
        if (userTokenCount == 1) {
            this.userTokens.remove(viewOwner);
        } else {
            this.userTokens.put(viewOwner, userTokenCount - 1);
        }
        logger.debug("Released view expansion token issued for user '{}'", (Object)viewOwner);
    }

    public class ViewExpansionToken {
        private final String viewOwner;
        private boolean released;

        ViewExpansionToken(String viewOwner) {
            this.viewOwner = viewOwner;
        }

        public SchemaPlus getSchemaTree() {
            Preconditions.checkState(!this.released, "Trying to use released token.");
            return ViewExpansionContext.this.schemaConfigInfoProvider.getRootSchema(this.viewOwner);
        }

        public void release() {
            if (!this.released) {
                this.released = true;
                ViewExpansionContext.this.releaseViewExpansionToken(this);
            }
        }
    }
}

