/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.ops.FragmentContext;
import oadd.org.apache.drill.exec.ops.MetricDef;
import oadd.org.apache.drill.exec.physical.base.PhysicalOperator;
import oadd.org.apache.drill.exec.record.AbstractRecordBatch;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.RecordBatchMemoryManager;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public abstract class AbstractBinaryRecordBatch<T extends PhysicalOperator>
extends AbstractRecordBatch<T> {
    private static final Logger logger = LoggerFactory.getLogger(new Object(){}.getClass().getEnclosingClass());
    protected final RecordBatch left;
    protected final RecordBatch right;
    protected RecordBatch.IterOutcome leftUpstream = RecordBatch.IterOutcome.NONE;
    protected RecordBatch.IterOutcome rightUpstream = RecordBatch.IterOutcome.NONE;
    protected RecordBatchMemoryManager batchMemoryManager;
    public final int numInputs = 2;
    public static final int LEFT_INDEX = 0;
    public static final int RIGHT_INDEX = 1;

    protected AbstractBinaryRecordBatch(T popConfig, FragmentContext context, RecordBatch left, RecordBatch right) throws OutOfMemoryException {
        super(popConfig, context, true, context.newOperatorContext((PhysicalOperator)popConfig));
        this.left = left;
        this.right = right;
    }

    protected AbstractBinaryRecordBatch(T popConfig, FragmentContext context, boolean buildSchema, RecordBatch left, RecordBatch right) throws OutOfMemoryException {
        super(popConfig, context, buildSchema);
        this.left = left;
        this.right = right;
    }

    protected boolean verifyOutcomeToSetBatchState(RecordBatch.IterOutcome leftOutcome, RecordBatch.IterOutcome rightOutcome) {
        if (leftOutcome == RecordBatch.IterOutcome.STOP || rightOutcome == RecordBatch.IterOutcome.STOP) {
            this.state = AbstractRecordBatch.BatchState.STOP;
            return false;
        }
        if (leftOutcome == RecordBatch.IterOutcome.OUT_OF_MEMORY || rightOutcome == RecordBatch.IterOutcome.OUT_OF_MEMORY) {
            this.state = AbstractRecordBatch.BatchState.OUT_OF_MEMORY;
            return false;
        }
        if (this.checkForEarlyFinish(leftOutcome, rightOutcome)) {
            this.state = AbstractRecordBatch.BatchState.DONE;
            return false;
        }
        if (leftOutcome == RecordBatch.IterOutcome.EMIT || rightOutcome == RecordBatch.IterOutcome.EMIT) {
            this.state = AbstractRecordBatch.BatchState.STOP;
            throw new IllegalStateException("Unexpected IterOutcome.EMIT received either from left or right side in buildSchema phase");
        }
        return true;
    }

    protected boolean prefetchFirstBatchFromBothSides() {
        this.leftUpstream = this.next(0, this.left);
        this.rightUpstream = this.next(1, this.right);
        return this.verifyOutcomeToSetBatchState(this.leftUpstream, this.rightUpstream);
    }

    protected boolean checkForEarlyFinish(RecordBatch.IterOutcome leftOutcome, RecordBatch.IterOutcome rightOutcome) {
        return leftOutcome == RecordBatch.IterOutcome.NONE && rightOutcome == RecordBatch.IterOutcome.NONE;
    }

    public RecordBatchMemoryManager getBatchMemoryManager() {
        return this.batchMemoryManager;
    }

    protected void updateBatchMemoryManagerStats() {
        this.stats.setLongStat(Metric.LEFT_INPUT_BATCH_COUNT, this.batchMemoryManager.getNumIncomingBatches(0));
        this.stats.setLongStat(Metric.LEFT_AVG_INPUT_BATCH_BYTES, this.batchMemoryManager.getAvgInputBatchSize(0));
        this.stats.setLongStat(Metric.LEFT_AVG_INPUT_ROW_BYTES, this.batchMemoryManager.getAvgInputRowWidth(0));
        this.stats.setLongStat(Metric.LEFT_INPUT_RECORD_COUNT, this.batchMemoryManager.getTotalInputRecords(0));
        this.stats.setLongStat(Metric.RIGHT_INPUT_BATCH_COUNT, this.batchMemoryManager.getNumIncomingBatches(1));
        this.stats.setLongStat(Metric.RIGHT_AVG_INPUT_BATCH_BYTES, this.batchMemoryManager.getAvgInputBatchSize(1));
        this.stats.setLongStat(Metric.RIGHT_AVG_INPUT_ROW_BYTES, this.batchMemoryManager.getAvgInputRowWidth(1));
        this.stats.setLongStat(Metric.RIGHT_INPUT_RECORD_COUNT, this.batchMemoryManager.getTotalInputRecords(1));
        this.stats.setLongStat(Metric.OUTPUT_BATCH_COUNT, this.batchMemoryManager.getNumOutgoingBatches());
        this.stats.setLongStat(Metric.AVG_OUTPUT_BATCH_BYTES, this.batchMemoryManager.getAvgOutputBatchSize());
        this.stats.setLongStat(Metric.AVG_OUTPUT_ROW_BYTES, this.batchMemoryManager.getAvgOutputRowWidth());
        this.stats.setLongStat(Metric.OUTPUT_RECORD_COUNT, this.batchMemoryManager.getTotalOutputRecords());
    }

    public static enum Metric implements MetricDef
    {
        LEFT_INPUT_BATCH_COUNT,
        LEFT_AVG_INPUT_BATCH_BYTES,
        LEFT_AVG_INPUT_ROW_BYTES,
        LEFT_INPUT_RECORD_COUNT,
        RIGHT_INPUT_BATCH_COUNT,
        RIGHT_AVG_INPUT_BATCH_BYTES,
        RIGHT_AVG_INPUT_ROW_BYTES,
        RIGHT_INPUT_RECORD_COUNT,
        OUTPUT_BATCH_COUNT,
        AVG_OUTPUT_BATCH_BYTES,
        AVG_OUTPUT_ROW_BYTES,
        OUTPUT_RECORD_COUNT;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

