/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.Set;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.RecordBatchMemoryManager;
import oadd.org.apache.drill.exec.record.RecordBatchSizer;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class JoinBatchMemoryManager
extends RecordBatchMemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(JoinBatchMemoryManager.class);
    private int[] rowWidth;
    private RecordBatch[] recordBatch = new RecordBatch[2];
    private Set<String> columnsToExclude;
    private static final int numInputs = 2;
    public static final int LEFT_INDEX = 0;
    public static final int RIGHT_INDEX = 1;

    public JoinBatchMemoryManager(int outputBatchSize, RecordBatch leftBatch, RecordBatch rightBatch, Set<String> excludedColumns) {
        super(2, outputBatchSize);
        this.recordBatch[0] = leftBatch;
        this.recordBatch[1] = rightBatch;
        this.rowWidth = new int[2];
        this.columnsToExclude = excludedColumns;
    }

    private void updateInternal(int inputIndex, int outputPosition, boolean useAggregate) {
        this.updateIncomingStats(inputIndex);
        this.rowWidth[inputIndex] = useAggregate ? (int)this.getAvgInputRowWidth(inputIndex) : this.getRecordBatchSizer(inputIndex).getRowAllocWidth();
        for (String columnName : this.columnsToExclude) {
            RecordBatchSizer.ColumnSize currentColSizer = this.getColumnSize(inputIndex, columnName);
            if (currentColSizer == null) continue;
            int n = inputIndex;
            this.rowWidth[n] = this.rowWidth[n] - currentColSizer.getAllocSizePerEntry();
        }
        int newOutgoingRowWidth = this.rowWidth[0] + this.rowWidth[1];
        if (newOutgoingRowWidth == 0 || newOutgoingRowWidth == this.getOutgoingRowWidth()) {
            return;
        }
        int previousOutgoingWidth = this.getOutgoingRowWidth();
        long memoryUsed = outputPosition * previousOutgoingWidth;
        int configOutputBatchSize = this.getOutputBatchSize();
        long remainingMemory = Math.max((long)configOutputBatchSize - memoryUsed, 0L);
        int numOutputRowsRemaining = RecordBatchSizer.safeDivide(remainingMemory, (long)newOutgoingRowWidth);
        int currentOutputBatchRowCount = this.getOutputRowCount();
        this.setOutputRowCount(configOutputBatchSize, newOutgoingRowWidth);
        this.setOutgoingRowWidth(newOutgoingRowWidth);
        int newOutputRowCount = this.getOutputRowCount();
        if (currentOutputBatchRowCount != newOutputRowCount) {
            logger.debug("Memory manager update changed the output row count from {} to {}", (Object)currentOutputBatchRowCount, (Object)newOutputRowCount);
        }
        this.setCurrentOutgoingMaxRowCount(Math.min(currentOutputBatchRowCount, outputPosition + numOutputRowsRemaining));
    }

    @Override
    public void update(int inputIndex, int outputPosition, boolean useAggregate) {
        this.setRecordBatchSizer(inputIndex, new RecordBatchSizer(this.recordBatch[inputIndex]));
        this.updateInternal(inputIndex, outputPosition, useAggregate);
    }

    @Override
    public void update(int inputIndex, int outputPosition) {
        this.update(inputIndex, outputPosition, false);
    }

    @Override
    public void update(RecordBatch batch, int inputIndex, int outputPosition, boolean useAggregate) {
        this.setRecordBatchSizer(inputIndex, new RecordBatchSizer(batch));
        this.updateInternal(inputIndex, outputPosition, useAggregate);
    }

    @Override
    public void update(RecordBatch batch, int inputIndex, int outputPosition) {
        this.update(batch, inputIndex, outputPosition, false);
    }
}

