/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.util.List;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnBuilder;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MapColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.RepeatedListColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleSchema;
import oadd.org.apache.drill.exec.record.metadata.VariantColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.VariantSchema;

public class MetadataUtils {
    public static TupleSchema fromFields(Iterable<MaterializedField> fields) {
        TupleSchema tuple = new TupleSchema();
        for (MaterializedField field : fields) {
            tuple.add(field);
        }
        return tuple;
    }

    public static ColumnMetadata fromField(MaterializedField field) {
        TypeProtos.MajorType majorType = field.getType();
        TypeProtos.MinorType type = majorType.getMinorType();
        switch (type) {
            case MAP: {
                return MetadataUtils.newMap(field);
            }
            case UNION: {
                if (field.getType().getMode() != TypeProtos.DataMode.OPTIONAL) {
                    throw new UnsupportedOperationException(type.name() + " type must be nullable");
                }
                return new VariantColumnMetadata(field);
            }
            case VARDECIMAL: {
                int precision = majorType.hasPrecision() ? majorType.getPrecision() : Types.maxPrecision(type);
                int scale = majorType.hasScale() ? majorType.getScale() : 0;
                return MetadataUtils.newDecimal(field.getName(), type, majorType.getMode(), precision, scale);
            }
            case LIST: {
                switch (field.getType().getMode()) {
                    case OPTIONAL: {
                        return new VariantColumnMetadata(field);
                    }
                    case REPEATED: {
                        return new RepeatedListColumnMetadata(field);
                    }
                }
                throw new UnsupportedOperationException(String.format("Unsupported mode %s for type %s", field.getType().getMode().name(), type.name()));
            }
        }
        return new PrimitiveColumnMetadata(field);
    }

    public static ColumnMetadata fromView(MaterializedField field) {
        if (field.getType().getMinorType() == TypeProtos.MinorType.MAP) {
            return new MapColumnMetadata(field, null);
        }
        return new PrimitiveColumnMetadata(field);
    }

    public static TupleSchema fromColumns(List<ColumnMetadata> columns) {
        TupleSchema tuple = new TupleSchema();
        for (ColumnMetadata column : columns) {
            tuple.add(column);
        }
        return tuple;
    }

    public static TupleMetadata fromBatchSchema(BatchSchema batchSchema) {
        TupleSchema tuple = new TupleSchema();
        for (MaterializedField field : batchSchema) {
            tuple.add(MetadataUtils.fromView(field));
        }
        return tuple;
    }

    public static MapColumnMetadata newMap(MaterializedField field, TupleSchema schema) {
        return new MapColumnMetadata(field, schema);
    }

    public static MapColumnMetadata newMap(MaterializedField field) {
        return new MapColumnMetadata(field, MetadataUtils.fromFields(field.getChildren()));
    }

    public static MapColumnMetadata newMap(String name, TupleMetadata schema) {
        return new MapColumnMetadata(name, TypeProtos.DataMode.REQUIRED, (TupleSchema)schema);
    }

    public static VariantColumnMetadata newVariant(MaterializedField field, VariantSchema schema) {
        return new VariantColumnMetadata(field, schema);
    }

    public static VariantColumnMetadata newVariant(String name, TypeProtos.DataMode cardinality) {
        switch (cardinality) {
            case OPTIONAL: {
                return new VariantColumnMetadata(name, TypeProtos.MinorType.UNION, new VariantSchema());
            }
            case REPEATED: {
                return new VariantColumnMetadata(name, TypeProtos.MinorType.LIST, new VariantSchema());
            }
        }
        throw new IllegalArgumentException();
    }

    public static RepeatedListColumnMetadata newRepeatedList(String name, ColumnMetadata child) {
        return new RepeatedListColumnMetadata(name, child);
    }

    public static ColumnMetadata newMapArray(String name, TupleMetadata schema) {
        return new MapColumnMetadata(name, TypeProtos.DataMode.REPEATED, (TupleSchema)schema);
    }

    public static PrimitiveColumnMetadata newScalar(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        assert (type != TypeProtos.MinorType.MAP && type != TypeProtos.MinorType.UNION && type != TypeProtos.MinorType.LIST);
        return new PrimitiveColumnMetadata(name, type, mode);
    }

    public static PrimitiveColumnMetadata newScalar(String name, TypeProtos.MajorType type) {
        TypeProtos.MinorType minorType = type.getMinorType();
        assert (minorType != TypeProtos.MinorType.MAP && minorType != TypeProtos.MinorType.UNION && minorType != TypeProtos.MinorType.LIST);
        return new PrimitiveColumnMetadata(name, type);
    }

    private static ColumnMetadata newDecimal(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode, int precision, int scale) {
        if (precision < 0) {
            throw new IllegalArgumentException("Precision cannot be negative : " + precision);
        }
        if (scale < 0) {
            throw new IllegalArgumentException("Scale cannot be negative : " + scale);
        }
        int maxPrecision = Types.maxPrecision(type);
        if (precision > maxPrecision) {
            throw new IllegalArgumentException(String.format("%s(%d, %d) exceeds maximum suppored precision of %d", type.toString(), precision, scale, maxPrecision));
        }
        if (scale > precision) {
            throw new IllegalArgumentException(String.format("%s(%d, %d) scale exceeds precision", type.toString(), precision, scale));
        }
        MaterializedField field = new ColumnBuilder(name, type).setMode(mode).setPrecisionAndScale(precision, scale).build();
        return new PrimitiveColumnMetadata(field);
    }
}

