/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.resourcemgr.NodeResources;
import oadd.org.apache.drill.exec.resourcemgr.config.ResourcePool;
import oadd.org.apache.drill.exec.resourcemgr.config.exception.QueueSelectionException;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.AbstractQueueSelectionPolicy;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.QueueSelectionPolicy;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class BestFitQueueSelection
extends AbstractQueueSelectionPolicy {
    private static final Logger logger = LoggerFactory.getLogger(BestFitQueueSelection.class);

    public BestFitQueueSelection() {
        super(QueueSelectionPolicy.SelectionPolicy.BESTFIT);
    }

    @Override
    public ResourcePool selectQueue(List<ResourcePool> allPools, QueryContext queryContext, NodeResources maxResourcePerNode) throws QueueSelectionException {
        if (allPools.isEmpty()) {
            throw new QueueSelectionException(String.format("There are no pools to apply %s selection policy pool for the query: %s", this.getSelectionPolicy().toString(), queryContext.getQueryId()));
        }
        allPools.sort(new BestFitComparator());
        long queryMaxNodeMemory = maxResourcePerNode.getMemoryInMB();
        ResourcePool selectedPool = allPools.get(0);
        Iterator<ResourcePool> iterator = allPools.iterator();
        while (iterator.hasNext()) {
            ResourcePool pool;
            selectedPool = pool = iterator.next();
            long poolMaxNodeMem = pool.getQueryQueue().getMaxQueryMemoryInMBPerNode();
            if (poolMaxNodeMem < queryMaxNodeMemory) continue;
            break;
        }
        logger.debug("Selected pool {} based on {} policy for query {}", selectedPool.getPoolName(), this.getSelectionPolicy().toString(), queryContext.getQueryId());
        return selectedPool;
    }

    private static class BestFitComparator
    implements Comparator<ResourcePool> {
        private BestFitComparator() {
        }

        @Override
        public int compare(ResourcePool o1, ResourcePool o2) {
            long pool1Value = o1.getQueryQueue().getMaxQueryMemoryInMBPerNode();
            long pool2Value = o2.getQueryQueue().getMaxQueryMemoryInMBPerNode();
            return Long.compare(pool1Value, pool2Value);
        }
    }
}

