/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy;

import java.util.List;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.resourcemgr.NodeResources;
import oadd.org.apache.drill.exec.resourcemgr.config.ResourcePool;
import oadd.org.apache.drill.exec.resourcemgr.config.exception.QueueSelectionException;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.AbstractQueueSelectionPolicy;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.QueueSelectionPolicy;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class DefaultQueueSelection
extends AbstractQueueSelectionPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultQueueSelection.class);

    public DefaultQueueSelection() {
        super(QueueSelectionPolicy.SelectionPolicy.DEFAULT);
    }

    @Override
    public ResourcePool selectQueue(List<ResourcePool> allPools, QueryContext queryContext, NodeResources maxResourcePerNode) throws QueueSelectionException {
        for (ResourcePool pool : allPools) {
            if (!pool.isDefaultPool()) continue;
            logger.debug("Selected default pool: {} for the query: {}", (Object)pool.getPoolName(), (Object)queryContext.getQueryId());
            return pool;
        }
        throw new QueueSelectionException(String.format("There is no default pool to select from list of pools provided for the query: %s", queryContext.getQueryId()));
    }
}

