/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy;

import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.AbstractQueueSelectionPolicy;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.BestFitQueueSelection;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.DefaultQueueSelection;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.QueueSelectionPolicy;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.RandomQueueSelection;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class QueueSelectionPolicyFactory {
    private static final Logger logger = LoggerFactory.getLogger(QueueSelectionPolicyFactory.class);

    public static QueueSelectionPolicy createSelectionPolicy(QueueSelectionPolicy.SelectionPolicy policy) {
        AbstractQueueSelectionPolicy selectionPolicy;
        logger.debug("Creating SelectionPolicy of type {}", (Object)policy);
        switch (policy) {
            case DEFAULT: {
                selectionPolicy = new DefaultQueueSelection();
                break;
            }
            case BESTFIT: {
                selectionPolicy = new BestFitQueueSelection();
                break;
            }
            case RANDOM: {
                selectionPolicy = new RandomQueueSelection();
                break;
            }
            default: {
                logger.info("QueueSelectionPolicy is not configured so proceeding with the bestfit as default policy");
                selectionPolicy = new BestFitQueueSelection();
            }
        }
        return selectionPolicy;
    }

    private QueueSelectionPolicyFactory() {
    }
}

