/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy;

import java.util.Collections;
import java.util.List;
import oadd.org.apache.drill.exec.ops.QueryContext;
import oadd.org.apache.drill.exec.resourcemgr.NodeResources;
import oadd.org.apache.drill.exec.resourcemgr.config.ResourcePool;
import oadd.org.apache.drill.exec.resourcemgr.config.exception.QueueSelectionException;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.AbstractQueueSelectionPolicy;
import oadd.org.apache.drill.exec.resourcemgr.config.selectionpolicy.QueueSelectionPolicy;
import shade.org.slf4j.Logger;
import shade.org.slf4j.LoggerFactory;

public class RandomQueueSelection
extends AbstractQueueSelectionPolicy {
    private static final Logger logger = LoggerFactory.getLogger(RandomQueueSelection.class);

    public RandomQueueSelection() {
        super(QueueSelectionPolicy.SelectionPolicy.RANDOM);
    }

    @Override
    public ResourcePool selectQueue(List<ResourcePool> allPools, QueryContext queryContext, NodeResources maxResourcePerNode) throws QueueSelectionException {
        if (allPools.size() == 0) {
            throw new QueueSelectionException(String.format("Input pool list is empty to apply %s selection policy", this.getSelectionPolicy().toString()));
        }
        Collections.shuffle(allPools);
        ResourcePool selectedPool = allPools.get(0);
        logger.debug("Selected random pool: {} for query: {}", (Object)selectedPool.getPoolName(), (Object)queryContext.getQueryId());
        return selectedPool;
    }
}

